/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.framework.redis.service.impl;

import com.fshows.framework.redis.JsonSerializer;
import com.fshows.framework.redis.component.RedisClient;
import com.fshows.framework.redis.service.AbstractRedisService;
import com.fshows.framework.redis.service.RedisStringService;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import redis.clients.jedis.JedisPool;

public class RedisStringServiceImpl
extends AbstractRedisService
implements RedisStringService {
    public RedisStringServiceImpl(JedisPool jedisPool, RedisClient redisClient) {
        super(jedisPool, redisClient);
    }

    @Override
    public <T> T get(String key, Class<T> tClass) {
        super.validateParam(key);
        byte[] result = this.redisClient.invoke(this.jedisPool, jedis -> jedis.get(key.getBytes()));
        if (result == null) {
            return null;
        }
        return JsonSerializer.deserialize(result, tClass);
    }

    @Override
    public String get(String key) {
        super.validateParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.get(key));
    }

    @Override
    public void set(String key, Object value) {
        this.validateParam(key, value);
        this.redisClient.invoke(this.jedisPool, jedis -> {
            jedis.set(key.getBytes(), JsonSerializer.serialize(value));
            return null;
        });
    }

    @Override
    public void set(String key, Object value, int seconds) {
        this.validateParam(key, value);
        this.redisClient.invoke(this.jedisPool, jedis -> {
            jedis.setex(key.getBytes(), this.fastCheckTtl(seconds), JsonSerializer.serialize(value));
            return null;
        });
    }

    @Override
    public void set(String key, Object value, Date date) {
        long milliSeconds = date.getTime();
        this.psetex(key, value, milliSeconds);
    }

    @Override
    public void set(String key, Object value, long timeOut, TimeUnit timeUnit) {
        long milliSeconds = TimeUnit.MILLISECONDS.convert(timeOut, timeUnit);
        this.psetex(key, value, milliSeconds);
    }

    @Override
    public void psetex(String key, Object value, long milliseconds) {
        this.validateParam(key, value);
        this.redisClient.invoke(this.jedisPool, jedis -> {
            jedis.psetex(key.getBytes(), milliseconds, JsonSerializer.serialize(value));
            return null;
        });
    }

    @Override
    public void set(String key, String value) {
        this.validateParam(key, value);
        this.redisClient.invoke(this.jedisPool, jedis -> {
            jedis.set(key, value);
            return null;
        });
    }

    @Override
    public void set(String key, String value, int seconds) {
        this.validateParam(key, value);
        this.redisClient.invoke(this.jedisPool, jedis -> {
            jedis.setex(key, this.fastCheckTtl(seconds), value);
            return null;
        });
    }

    @Override
    public void set(String key, String value, Date date) {
        long milliSeconds = date.getTime();
        this.psetex(key, value, milliSeconds);
    }

    @Override
    public void set(String key, String value, long timeOut, TimeUnit timeUnit) {
        long milliSeconds = TimeUnit.MILLISECONDS.convert(timeOut, timeUnit);
        this.psetex(key, value, milliSeconds);
    }

    @Override
    public void psetex(String key, String value, long milliseconds) {
        this.validateParam(key, value);
        this.redisClient.invoke(this.jedisPool, jedis -> {
            jedis.psetex(key, milliseconds, value);
            return null;
        });
    }
}

