/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.framework.redis.service.impl;

import com.fshows.framework.redis.component.RedisClient;
import com.fshows.framework.redis.service.AbstractRedisService;
import com.fshows.framework.redis.service.RedisSortSetService;
import java.util.Set;
import redis.clients.jedis.JedisPool;

public class RedisSortSetServiceImpl
extends AbstractRedisService
implements RedisSortSetService {
    public RedisSortSetServiceImpl(JedisPool jedisPool, RedisClient redisClient) {
        super(jedisPool, redisClient);
    }

    @Override
    public long zadd(String key, String hash, double score) {
        this.validateParam(key, hash);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.zadd(key, score, hash));
    }

    @Override
    public long zcard(String key) {
        this.validateParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.zcard(key));
    }

    @Override
    public Set<String> zrange(String key, long start, long end) {
        this.validateParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.zrange(key, start, end));
    }

    @Override
    public Set<String> zrangebyscore(String key, double min, double max) {
        this.validateParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.zrangeByScore(key, min, max));
    }

    @Override
    public long zrem(String key, String ... hashs) {
        this.validateParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.zrem(key, hashs));
    }
}

