/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.framework.redis.service.impl;

import com.fshows.framework.redis.JsonSerializer;
import com.fshows.framework.redis.component.RedisClient;
import com.fshows.framework.redis.service.AbstractRedisService;
import com.fshows.framework.redis.service.RedisListService;
import java.util.ArrayList;
import java.util.List;
import redis.clients.jedis.JedisPool;

public class RedisListServiceImpl
extends AbstractRedisService
implements RedisListService {
    public RedisListServiceImpl(JedisPool jedisPool, RedisClient redisClient) {
        super(jedisPool, redisClient);
    }

    @Override
    public long llen(String key) {
        this.validateParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.llen(key));
    }

    @Override
    public long lpush(String key, String value) {
        this.validateParam(key, value);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.lpush(key, new String[]{value}));
    }

    @Override
    public long lpush(String key, Object value) {
        this.validateParam(key, value);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.lpush(key.getBytes(), (byte[][])new byte[][]{JsonSerializer.serialize(value)}));
    }

    @Override
    public long rpush(String key, String value) {
        this.validateParam(key, value);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.rpush(key, new String[]{value}));
    }

    @Override
    public long rpush(String key, Object value) {
        this.validateParam(key, value);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.rpush(key.getBytes(), (byte[][])new byte[][]{JsonSerializer.serialize(value)}));
    }

    @Override
    public String lpop(String key) {
        this.validateParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.lpop(key));
    }

    @Override
    public <T> T lpop(String key, Class<T> tClass) {
        this.validateParam(key);
        byte[] bytes = this.redisClient.invoke(this.jedisPool, jedis -> jedis.lpop(key.getBytes()));
        return JsonSerializer.deserialize(bytes, tClass);
    }

    @Override
    public String rpop(String key) {
        this.validateParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.rpop(key));
    }

    @Override
    public <T> T rpop(String key, Class<T> tClass) {
        byte[] bytes = this.redisClient.invoke(this.jedisPool, jedis -> jedis.rpop(key.getBytes()));
        return JsonSerializer.deserialize(bytes, tClass);
    }

    @Override
    public String lindex(String key, long index) {
        this.validateParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.lindex(key, index));
    }

    @Override
    public <T> T lindex(String key, long index, Class<T> tClass) {
        this.validateParam(key);
        byte[] bytes = this.redisClient.invoke(this.jedisPool, jedis -> jedis.lindex(key.getBytes(), index));
        return JsonSerializer.deserialize(bytes, tClass);
    }

    @Override
    public List<String> lrange(String key, long start, long end) {
        this.validateParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.lrange(key, start, end));
    }

    @Override
    public <T> List<T> lrange(String key, long start, long end, Class<T> tClass) {
        this.validateParam(key);
        List bytesList = this.redisClient.invoke(this.jedisPool, jedis -> jedis.lrange(key.getBytes(), start, end));
        ArrayList list = new ArrayList();
        bytesList.stream().forEach(bytes -> {
            Object t = JsonSerializer.deserialize(bytes, tClass);
            list.add(t);
        });
        return list;
    }
}

