/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.framework.redis.service.impl;

import com.fshows.framework.redis.component.RedisClient;
import com.fshows.framework.redis.service.AbstractRedisService;
import com.fshows.framework.redis.service.RedisKeyService;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import redis.clients.jedis.JedisPool;

public class RedisKeyServiceImpl
extends AbstractRedisService
implements RedisKeyService {
    public RedisKeyServiceImpl(JedisPool jedisPool, RedisClient redisClient) {
        super(jedisPool, redisClient);
    }

    @Override
    public boolean hasKey(String key) {
        this.validateParam(key);
        Boolean result = this.redisClient.invoke(this.jedisPool, jedis -> jedis.exists(key));
        return result;
    }

    @Override
    public long expire(String key, int seconds) {
        this.validateParam(key);
        long ttl = this.redisClient.invoke(this.jedisPool, jedis -> jedis.expire(key.getBytes(), this.fastCheckTtl(seconds)));
        return ttl;
    }

    @Override
    public long expireAt(String key, long unixTime) {
        this.validateParam(key);
        long ttl = this.redisClient.invoke(this.jedisPool, jedis -> jedis.expireAt(key.getBytes(), unixTime));
        return ttl;
    }

    @Override
    public long expireAt(String key, Date date) {
        long millisecondsTimestamp = date.getTime();
        return this.pexpireAt(key, millisecondsTimestamp);
    }

    @Override
    public long pexpireAt(String key, long millisecondsTimestamp) {
        this.validateParam(key);
        long ttl = this.redisClient.invoke(this.jedisPool, jedis -> jedis.pexpireAt(key.getBytes(), millisecondsTimestamp));
        return ttl;
    }

    @Override
    public long expire(String key, long timeOut, TimeUnit timeUnit) {
        this.validateParam(key);
        long milliSeconds = TimeUnit.MILLISECONDS.convert(timeOut, timeUnit);
        long ttl = this.redisClient.invoke(this.jedisPool, jedis -> jedis.pexpire(key.getBytes(), milliSeconds));
        return ttl;
    }

    @Override
    public long del(String key) {
        this.validateParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.del(key.getBytes()));
    }

    @Override
    public long incr(String key) {
        this.validateParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.incr(key.getBytes()));
    }

    @Override
    public long incrby(String key, long num) {
        this.validateParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.incrBy(key.getBytes(), num));
    }
}

