/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.framework.redis.service;

import com.fshows.framework.redis.component.RedisClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public abstract class AbstractRedisService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRedisService.class);
    public static final int DEFAULT_CACHE_SECONDS = 300000;
    protected RedisClient redisClient;
    protected JedisPool jedisPool;

    protected AbstractRedisService(JedisPool jedisPool, RedisClient redisClient) {
        this.jedisPool = jedisPool;
        this.redisClient = redisClient;
    }

    protected void validateParamHash(Object ... values) {
        for (Object value : values) {
            if (value instanceof String) {
                this.hasText((String)value, "Redis Hash\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            this.notNull(value, "Redis Hash\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.notNull(this.jedisPool, "jedis\u8fde\u63a5\u521d\u59cb\u5316\u5931\u8d25");
    }

    protected void validateParam(String key) {
        this.hasText(key, "key\u4e0d\u80fd\u4e3a\u7a7a");
        this.notNull(this.jedisPool, "jedis\u8fde\u63a5\u521d\u59cb\u5316\u5931\u8d25");
    }

    protected void validateParam(String key, String value) {
        this.hasText(key, "key\u4e0d\u80fd\u4e3a\u7a7a");
        this.hasText(value, "value\u4e0d\u80fd\u4e3a\u7a7a");
        this.notNull(this.jedisPool, "jedis\u8fde\u63a5\u521d\u59cb\u5316\u5931\u8d25");
    }

    protected void validateParam(String key, Object value) {
        this.hasText(key, "key\u4e0d\u80fd\u4e3a\u7a7a");
        this.notNull(value, "value\u4e0d\u80fd\u4e3a\u7a7a");
        this.notNull(this.jedisPool, "jedis\u8fde\u63a5\u521d\u59cb\u5316\u5931\u8d25");
        AbstractRedisService.isInstanceOf(Object.class, value, "value\u6ca1\u6709\u5b9e\u73b0Object\u63a5\u53e3\uff0c\u65e0\u6cd5\u5e8f\u5217\u5316");
    }

    protected int fastCheckTtl(int seconds) {
        if (seconds <= 0) {
            return 300000;
        }
        return seconds;
    }

    protected synchronized Jedis getJedis() {
        Jedis jedis = null;
        if (this.jedisPool != null) {
            jedis = this.jedisPool.getResource();
        }
        return jedis;
    }

    protected void returnBrokenResource(Jedis jedis) {
        if (jedis == null) {
            return;
        }
        try {
            jedis.close();
        }
        catch (Exception e) {
            LOGGER.error("returnBrokenResource error.", (Throwable)e);
        }
    }

    protected void returnResource(Jedis jedis) {
        try {
            jedis.close();
        }
        catch (Exception e) {
            LOGGER.error("returnResource error.", (Throwable)e);
        }
    }

    public void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public void hasText(String object, String message) {
        if (object == null || object.equals("")) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isInstanceOf(Class<?> type, Object obj, String message) {
        if (!type.isInstance(obj)) {
            throw new IllegalArgumentException(message + "Object of class [" + (obj != null ? obj.getClass().getName() : "null") + "] must be an instance of " + type);
        }
    }
}

