/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.framework.redis.service.impl;

import com.fshows.framework.redis.component.RedisClient;
import com.fshows.framework.redis.service.AbstractRedisService;
import com.fshows.framework.redis.service.RedisPipeLineService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

public class RedisPipeLineServiceImpl
extends AbstractRedisService
implements RedisPipeLineService {
    public RedisPipeLineServiceImpl(JedisPool jedisPool, RedisClient redisClient) {
        super(jedisPool, redisClient);
    }

    @Override
    public List<Map<String, String>> mGetHashAllPipe(List<String> keys) {
        this.validateParamHash(keys);
        ArrayList resResult = Lists.newArrayList();
        ArrayList result = Lists.newArrayList();
        this.redisClient.invoke(this.jedisPool, jedis -> {
            Pipeline pipelined = jedis.pipelined();
            for (String key : keys) {
                Response allHashs = pipelined.hgetAll(key);
                resResult.add(allHashs);
            }
            pipelined.sync();
            return null;
        });
        if (CollectionUtils.isEmpty((Collection)resResult)) {
            return result;
        }
        for (Response res : resResult) {
            result.add(res.get());
        }
        return result;
    }
}

