/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.framework.redis.service.impl;

import com.fshows.framework.redis.component.RedisClient;
import com.fshows.framework.redis.service.AbstractRedisService;
import com.fshows.framework.redis.service.RedisLockService;
import java.util.Collections;
import redis.clients.jedis.JedisPool;

public class RedisLockServiceImpl
extends AbstractRedisService
implements RedisLockService {
    private static final Long RELEASE_SUCCESS = 1L;
    private static final String DEFAULT_LOCK_VALUE = "1";
    private static final String LOCK_SUCCESS = "OK";
    private static final String SET_IF_NOT_EXIST = "NX";
    private static final String SET_WITH_EXPIRE_TIME = "PX";

    public RedisLockServiceImpl(JedisPool jedisPool, RedisClient redisClient) {
        super(jedisPool, redisClient);
    }

    @Override
    public boolean tryGetLock(String lockKey, String requestId, int expireTime) {
        this.validateParam(lockKey, requestId);
        String result = this.redisClient.invoke(this.jedisPool, jedis -> jedis.set(lockKey, requestId, SET_IF_NOT_EXIST, SET_WITH_EXPIRE_TIME, expireTime));
        return LOCK_SUCCESS.equals(result);
    }

    @Override
    public boolean tryGetLock(String lockKey, int expireTime) {
        return this.tryGetLock(lockKey, DEFAULT_LOCK_VALUE, expireTime);
    }

    @Override
    public boolean releaseLock(String lockKey, String requestId) {
        this.validateParam(lockKey, requestId);
        return this.redisClient.invoke(this.jedisPool, jedis -> {
            String script = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
            Object result = jedis.eval(script, Collections.singletonList(lockKey), Collections.singletonList(requestId));
            if (RELEASE_SUCCESS.equals(result)) {
                return true;
            }
            return false;
        });
    }

    @Override
    public void releaseLock(String lockKey) {
        this.validateParam(lockKey);
        this.redisClient.invoke(this.jedisPool, jedis -> {
            jedis.del(lockKey);
            return null;
        });
    }
}

