/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.framework.redis.service.impl;

import com.fshows.framework.redis.JsonSerializer;
import com.fshows.framework.redis.component.RedisClient;
import com.fshows.framework.redis.service.AbstractRedisService;
import com.fshows.framework.redis.service.RedisHashService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import redis.clients.jedis.JedisPool;

public class RedisHashServiceImpl
extends AbstractRedisService
implements RedisHashService {
    public RedisHashServiceImpl(JedisPool jedisPool, RedisClient redisClient) {
        super(jedisPool, redisClient);
    }

    @Override
    public Long delete(String hash, String ... hashKeys) {
        this.validateParamHash(hash, hashKeys);
        Long result = this.redisClient.invoke(this.jedisPool, jedis -> jedis.hdel(hash, hashKeys));
        return result;
    }

    @Override
    public Boolean hasKey(String hash, String hashKey) {
        this.validateParamHash(hash, hashKey);
        Boolean result = this.redisClient.invoke(this.jedisPool, jedis -> jedis.hexists(hash, hashKey));
        return result;
    }

    @Override
    public String get(String hash, String hashKey) {
        this.validateParamHash(hash, hashKey);
        String result = this.redisClient.invoke(this.jedisPool, jedis -> jedis.hget(hash, hashKey));
        return result;
    }

    @Override
    public <T> T get(String hash, String hashKey, Class<T> tClass) {
        this.validateParamHash(hash, hashKey);
        byte[] bytes = this.redisClient.invoke(this.jedisPool, jedis -> jedis.hget(hash.getBytes(), hashKey.getBytes()));
        return JsonSerializer.deserialize(bytes, tClass);
    }

    @Override
    public List<String> multiGet(String hash, Collection<String> hashKeys) {
        this.validateParamHash(hash, hashKeys);
        List result = this.redisClient.invoke(this.jedisPool, jedis -> jedis.hmget(hash, hashKeys.toArray(new String[0])));
        return result;
    }

    @Override
    public <T> List<T> multiGet(String hash, Collection<String> hashKeys, Class<T> tClass) {
        List hashKeyBytes = hashKeys.stream().map(s -> s.getBytes()).collect(Collectors.toList());
        this.validateParamHash(hash, hashKeys);
        List byteList = this.redisClient.invoke(this.jedisPool, jedis -> jedis.hmget(hash.getBytes(), (byte[][])hashKeyBytes.toArray((T[])new byte[0][])));
        ArrayList list = new ArrayList();
        byteList.stream().forEach(bytes -> list.add(JsonSerializer.deserialize(bytes, tClass)));
        return list;
    }

    @Override
    public Long increment(String hash, String hashKey, long var) {
        this.validateParamHash(hash, hashKey, var);
        Long result = this.redisClient.invoke(this.jedisPool, jedis -> jedis.hincrBy(hash, hash, var));
        return result;
    }

    @Override
    public Long increment(String hash, String hashKey, long var, long timeOut, TimeUnit timeUnit) {
        Long result = this.increment(hash, hashKey, var);
        this.expire(hash, timeOut, timeUnit);
        return result;
    }

    @Override
    public Double increment(String hash, String hashKey, double var) {
        this.validateParamHash(hash, hashKey, var);
        Double result = this.redisClient.invoke(this.jedisPool, jedis -> jedis.hincrByFloat(hash, hash, var));
        return result;
    }

    @Override
    public Double increment(String hash, String hashKey, double var, long timeOut, TimeUnit timeUnit) {
        Double result = this.increment(hash, hashKey, var);
        this.expire(hash, timeOut, timeUnit);
        return result;
    }

    @Override
    public Set<String> keys(String hash) {
        this.validateParamHash(hash);
        Set result = this.redisClient.invoke(this.jedisPool, jedis -> jedis.hkeys(hash));
        return result;
    }

    @Override
    public Long size(String hash) {
        this.validateParamHash(hash);
        Long result = this.redisClient.invoke(this.jedisPool, jedis -> jedis.hlen(hash));
        return result;
    }

    @Override
    public <T> String putAll(String hash, Map<String, T> hashValue) {
        this.validateParamHash(hash, hashValue);
        HashMap mapByte = new HashMap();
        hashValue.forEach((key, val) -> mapByte.put(key.getBytes(), JsonSerializer.serialize(val)));
        String result = this.redisClient.invoke(this.jedisPool, jedis -> jedis.hmset(hash.getBytes(), mapByte));
        return result;
    }

    @Override
    public Long put(String hash, String hashKey, String val) {
        this.validateParamHash(hash, hashKey, val);
        Long result = this.redisClient.invoke(this.jedisPool, jedis -> jedis.hset(hash, hashKey, val));
        return result;
    }

    @Override
    public Long put(String hash, String hashKey, String val, long timeOut, TimeUnit timeUnit) {
        Long result = this.put(hash, hashKey, val);
        this.expire(hash, timeOut, timeUnit);
        return result;
    }

    @Override
    public <T> Long put(String hash, String hashKey, T val) {
        this.validateParamHash(hash, hashKey, val);
        Long result = this.redisClient.invoke(this.jedisPool, jedis -> jedis.hset(hash.getBytes(), hashKey.getBytes(), JsonSerializer.serialize(val)));
        return result;
    }

    @Override
    public <T> Long put(String hash, String hashKey, T val, long timeOut, TimeUnit timeUnit) {
        Long result = this.put(hash, hashKey, val);
        this.expire(hash, timeOut, timeUnit);
        return result;
    }

    @Override
    public Boolean putIfAbsent(String hash, String hashKey, String val) {
        this.validateParamHash(hash, hashKey, val);
        Boolean result = this.redisClient.invoke(this.jedisPool, jedis -> jedis.hsetnx(hash, hashKey, val) == 1L);
        return result;
    }

    @Override
    public <T> Boolean putIfAbsent(String hash, String hashKey, T val) {
        this.validateParamHash(hash, hashKey, val);
        Boolean result = this.redisClient.invoke(this.jedisPool, jedis -> jedis.hsetnx(hash.getBytes(), hashKey.getBytes(), JsonSerializer.serialize(val)) == 1L);
        return result;
    }

    @Override
    public List<String> values(String hash) {
        this.validateParamHash(hash);
        List result = this.redisClient.invoke(this.jedisPool, jedis -> jedis.hvals(hash));
        return result;
    }

    @Override
    public Map<String, String> entries(String hash) {
        this.validateParamHash(hash);
        Map result = this.redisClient.invoke(this.jedisPool, jedis -> jedis.hgetAll(hash));
        return result;
    }

    @Override
    public <T> Map<String, T> entries(String hash, Class<T> tClass) {
        this.validateParamHash(hash);
        HashMap map = new HashMap();
        Map mapBytes = this.redisClient.invoke(this.jedisPool, jedis -> jedis.hgetAll(hash.getBytes()));
        mapBytes.forEach((key, val) -> map.put(new String((byte[])key), JsonSerializer.deserialize(val, tClass)));
        return map;
    }

    private void expire(String key, int seconds) {
        this.redisClient.invoke(this.jedisPool, jedis -> jedis.expire(key.getBytes(), this.fastCheckTtl(seconds)));
    }

    private void expire(String key, long timeOut, TimeUnit timeUnit) {
        long milliSeconds = TimeUnit.MILLISECONDS.convert(timeOut, timeUnit);
        long ttl = this.redisClient.invoke(this.jedisPool, jedis -> jedis.pexpire(key.getBytes(), milliSeconds));
    }
}

