/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.framework.redis.service;

import com.fshows.framework.redis.component.RedisClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public abstract class AbstractRedisService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRedisService.class);
    public static final int DEFAULT_CACHE_SECONDS = 300000;
    protected RedisClient redisClient;
    protected JedisPool jedisPool;

    protected AbstractRedisService(JedisPool jedisPool, RedisClient redisClient) {
        this.jedisPool = jedisPool;
        this.redisClient = redisClient;
    }

    protected void validateParamHash(Object ... values) {
        for (Object value : values) {
            if (value instanceof String) {
                this.hasText((String)value, "Redis Hash\u9359\u509b\u669f\u6d93\u5d88\u5158\u6d93\u8679\u2516");
                continue;
            }
            this.notNull(value, "Redis Hash\u9359\u509b\u669f\u6d93\u5d88\u5158\u6d93\u8679\u2516");
        }
        this.notNull(this.jedisPool, "jedis\u6769\u70b4\u5e34\u9352\u6fc6\ue750\u9356\u6827\u3051\u7490\ufffd");
    }

    protected void validateParam(String key) {
        this.hasText(key, "key\u6d93\u5d88\u5158\u6d93\u8679\u2516");
        this.notNull(this.jedisPool, "jedis\u6769\u70b4\u5e34\u9352\u6fc6\ue750\u9356\u6827\u3051\u7490\ufffd");
    }

    protected void validateParam(String key, String value) {
        this.hasText(key, "key\u6d93\u5d88\u5158\u6d93\u8679\u2516");
        this.hasText(value, "value\u6d93\u5d88\u5158\u6d93\u8679\u2516");
        this.notNull(this.jedisPool, "jedis\u6769\u70b4\u5e34\u9352\u6fc6\ue750\u9356\u6827\u3051\u7490\ufffd");
    }

    protected void validateParam(String key, Object value) {
        this.hasText(key, "key\u6d93\u5d88\u5158\u6d93\u8679\u2516");
        this.notNull(value, "value\u6d93\u5d88\u5158\u6d93\u8679\u2516");
        this.notNull(this.jedisPool, "jedis\u6769\u70b4\u5e34\u9352\u6fc6\ue750\u9356\u6827\u3051\u7490\ufffd");
        AbstractRedisService.isInstanceOf(Object.class, value, "value\u5a0c\u2103\u6e41\u7039\u70b5\u5e47Object\u93ba\u30e5\u5f5b\u951b\u5c7e\u68e4\u5a09\u66de\u7c2d\u9352\u6940\u5bf2");
    }

    protected int fastCheckTtl(int seconds) {
        if (seconds <= 0) {
            return 300000;
        }
        return seconds;
    }

    protected synchronized Jedis getJedis() {
        Jedis jedis = null;
        if (this.jedisPool != null) {
            jedis = this.jedisPool.getResource();
        }
        return jedis;
    }

    protected void returnBrokenResource(Jedis jedis) {
        if (jedis == null) {
            return;
        }
        try {
            jedis.close();
        }
        catch (Exception e) {
            LOGGER.error("returnBrokenResource error.", (Throwable)e);
        }
    }

    protected void returnResource(Jedis jedis) {
        try {
            jedis.close();
        }
        catch (Exception e) {
            LOGGER.error("returnResource error.", (Throwable)e);
        }
    }

    public void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public void hasText(String object, String message) {
        if (object == null || object.equals("")) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isInstanceOf(Class<?> type, Object obj, String message) {
        if (!type.isInstance(obj)) {
            throw new IllegalArgumentException(message + "Object of class [" + (obj != null ? obj.getClass().getName() : "null") + "] must be an instance of " + type);
        }
    }
}

