/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.framework.redis.client;

import com.fshows.framework.redis.component.RedisClient;
import com.fshows.framework.redis.service.RedisHashService;
import com.fshows.framework.redis.service.RedisHyperLogLogService;
import com.fshows.framework.redis.service.RedisKeyService;
import com.fshows.framework.redis.service.RedisListService;
import com.fshows.framework.redis.service.RedisLockService;
import com.fshows.framework.redis.service.RedisPipeLineService;
import com.fshows.framework.redis.service.RedisSortSetService;
import com.fshows.framework.redis.service.RedisStringService;
import com.fshows.framework.redis.service.impl.RedisHashServiceImpl;
import com.fshows.framework.redis.service.impl.RedisHyperLogLogImpl;
import com.fshows.framework.redis.service.impl.RedisKeyServiceImpl;
import com.fshows.framework.redis.service.impl.RedisListServiceImpl;
import com.fshows.framework.redis.service.impl.RedisLockServiceImpl;
import com.fshows.framework.redis.service.impl.RedisPipeLineServiceImpl;
import com.fshows.framework.redis.service.impl.RedisSortSetServiceImpl;
import com.fshows.framework.redis.service.impl.RedisStringServiceImpl;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class FsRedisClient {
    private static final int DEFAULT_TIME_OUT_MS = 5000;
    private JedisPool jedisPool;
    private RedisClient redisClient;
    private RedisKeyService redisKeyService;
    private RedisStringService redisStringService;
    private RedisLockService redisLockService;
    private RedisHashService redisHashService;
    private RedisSortSetService redisSortSetService;
    private RedisPipeLineService redisPipeLineService;
    private RedisListService redisListService;
    private RedisHyperLogLogService redisHyperLogLogService;

    public FsRedisClient(String host, int port, int timeout, String password, JedisPoolConfig jedisPoolConfig) {
        this.jedisPool = new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, host, port, timeout, password);
        this.redisClient = new RedisClient();
        this.initClient();
    }

    public FsRedisClient(String host, int port, int timeout, JedisPoolConfig jedisPoolConfig) {
        this.jedisPool = new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, host, port, timeout);
        this.redisClient = new RedisClient();
        this.initClient();
    }

    public FsRedisClient(String host, int port, String password, JedisPoolConfig jedisPoolConfig) {
        this.jedisPool = new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, host, port, 5000, password);
        this.redisClient = new RedisClient();
        this.initClient();
    }

    public RedisKeyService key() {
        return this.redisKeyService;
    }

    public RedisStringService string() {
        return this.redisStringService;
    }

    public RedisLockService lock() {
        return this.redisLockService;
    }

    public RedisHashService hash() {
        return this.redisHashService;
    }

    public RedisSortSetService zset() {
        return this.redisSortSetService;
    }

    public RedisListService list() {
        return this.redisListService;
    }

    public RedisPipeLineService pipeline() {
        return this.redisPipeLineService;
    }

    public RedisHyperLogLogService hll() {
        return this.redisHyperLogLogService;
    }

    public JedisPool getJedisPool() {
        return this.jedisPool;
    }

    public Jedis getJedisInstance() {
        return this.jedisPool.getResource();
    }

    private void initClient() {
        this.redisKeyService = new RedisKeyServiceImpl(this.jedisPool, this.redisClient);
        this.redisStringService = new RedisStringServiceImpl(this.jedisPool, this.redisClient);
        this.redisLockService = new RedisLockServiceImpl(this.jedisPool, this.redisClient);
        this.redisHashService = new RedisHashServiceImpl(this.jedisPool, this.redisClient);
        this.redisSortSetService = new RedisSortSetServiceImpl(this.jedisPool, this.redisClient);
        this.redisPipeLineService = new RedisPipeLineServiceImpl(this.jedisPool, this.redisClient);
        this.redisListService = new RedisListServiceImpl(this.jedisPool, this.redisClient);
        this.redisHyperLogLogService = new RedisHyperLogLogImpl(this.jedisPool, this.redisClient);
    }
}

