/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.finance.business.service.base.impl;

import com.alibaba.fastjson.JSON;
import com.fshows.finance.business.dal.dao.BaseConfigDAO;
import com.fshows.finance.business.dal.dataobject.BaseConfigDO;
import com.fshows.finance.business.service.base.SelectValueBaseService;
import com.fshows.finance.common.redis.RedisCache;
import com.fshows.finance.common.tool.biz.BaseConfigUtil;
import com.fshows.finance.common.tool.util.ListUtils;
import com.fshows.finance.common.tool.util.StringUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SelectValueBaseServiceImpl
implements SelectValueBaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectValueBaseServiceImpl.class);
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private BaseConfigDAO baseConfigDAO;

    @Override
    public Map<String, String> getTypeMap(String type) {
        Boolean existsFlag = this.redisCache.hexists("select.list.config", type);
        LOGGER.info("\u7f13\u5b58\u4e2d\u662f\u5426\u5b58\u5728 existsFlag={}", (Object)existsFlag);
        if (existsFlag.booleanValue()) {
            return this.getFromCache(type);
        }
        return this.getFormDBAndFlushCache(type);
    }

    @Override
    public Map<String, String> getBatchTypeMap(List<String> typeList) {
        List valueList = this.redisCache.hmget("select.list.config", typeList, String.class);
        if (ListUtils.isNotEmpty((List)valueList)) {
            LOGGER.info("\u6279\u91cf\u83b7\u53d6\u914d\u7f6e\u6587\u672c\u63cf\u8ff0\u7f13\u5b58 >>> \u5b58\u5728");
            return this.getBatchFromCache(valueList);
        }
        LOGGER.info("\u6279\u91cf\u83b7\u53d6\u914d\u7f6e\u6587\u672c\u63cf\u8ff0\u7f13\u5b58 >>> \u4e0d\u5b58\u5728");
        return this.getBatchFromDB(typeList);
    }

    private Map<String, String> getBatchFromCache(List<String> valueList) {
        HashMap result = Maps.newHashMap();
        for (String strJson : valueList) {
            List baseConfigList = JSON.parseArray((String)strJson, BaseConfigDO.class);
            if (!ListUtils.isNotEmpty((List)baseConfigList)) continue;
            for (BaseConfigDO baseConfigDO : baseConfigList) {
                String key = BaseConfigUtil.getTypekey((String)baseConfigDO.getType(), (String)baseConfigDO.getBaseCode());
                result.put(key, baseConfigDO.getBaseName());
            }
        }
        return result;
    }

    private Map<String, String> getBatchFromDB(List<String> typeList) {
        List<BaseConfigDO> configDOList = this.baseConfigDAO.getBaseNameByTypeList(typeList);
        if (ListUtils.isEmpty(configDOList)) {
            return Maps.newHashMap();
        }
        HashMap result = Maps.newHashMap();
        for (BaseConfigDO baseConfigDO : configDOList) {
            String key = BaseConfigUtil.getTypekey((String)baseConfigDO.getType(), (String)baseConfigDO.getBaseCode());
            result.put(key, baseConfigDO.getBaseName());
        }
        return result;
    }

    private Map<String, String> getFromCache(String field) {
        String value = (String)this.redisCache.hGet("select.list.config", field, String.class);
        if (StringUtils.isEmpty((String)value)) {
            return Maps.newHashMap();
        }
        List baseConfigList = JSON.parseArray((String)value, BaseConfigDO.class);
        if (ListUtils.isEmpty((List)baseConfigList)) {
            return Maps.newHashMap();
        }
        HashMap valueMap = Maps.newHashMap();
        for (BaseConfigDO configDO : baseConfigList) {
            valueMap.put(configDO.getBaseCode(), configDO.getBaseName());
        }
        return valueMap;
    }

    private Map<String, String> getFormDBAndFlushCache(String type) {
        List<BaseConfigDO> baseConfigDOList = this.baseConfigDAO.getBaseNameByType(type);
        if (ListUtils.isEmpty(baseConfigDOList)) {
            LOGGER.info("\u4e1a\u52a1\u7c7b\u578b {} \u5bf9\u5e94\u7684\u914d\u7f6e\u8868\u6570\u636e\u4e3a\u7a7a", (Object)type);
            return Maps.newHashMap();
        }
        this.redisCache.hSet("select.list.config", type, baseConfigDOList);
        HashMap valueMap = Maps.newHashMap();
        for (BaseConfigDO configDO : baseConfigDOList) {
            valueMap.put(configDO.getBaseCode(), configDO.getBaseName());
        }
        return valueMap;
    }
}

