/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.finance.business.service.admin.permission.impl;

import com.alibaba.fastjson.JSON;
import com.fshows.finance.business.dal.dao.UserDAO;
import com.fshows.finance.business.dal.dataobject.UserDO;
import com.fshows.finance.business.result.admin.permission.LoginResult;
import com.fshows.finance.business.result.admin.permission.UserResult;
import com.fshows.finance.business.service.admin.permission.CaptchaService;
import com.fshows.finance.business.service.admin.permission.UserService;
import com.fshows.finance.business.vo.admin.permission.LoginUserVO;
import com.fshows.finance.business.vo.admin.permission.UserLoginVO;
import com.fshows.finance.business.vo.admin.permission.UserVO;
import com.fshows.finance.common.enums.permission.UserStatusEnum;
import com.fshows.finance.common.exception.BusinessException;
import com.fshows.finance.common.exception.EnumInterface;
import com.fshows.finance.common.exception.permission.PermissionExceptionEnum;
import com.fshows.finance.common.tool.util.BeanCopierUtil;
import com.fshows.finance.common.tool.util.MD5Util;
import com.fshows.finance.common.tool.util.RSAUtils;
import com.google.common.base.Objects;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import sun.misc.BASE64Decoder;

@Service
public class UserServiceImpl
implements UserService {
    private final Logger logger = LoggerFactory.getLogger(UserServiceImpl.class);
    public static final int accountLockTime = 3600000;
    public static final String passwordPrivateKey = "MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAOn0VpaVlz92gdeK\\\n                            XrQ1wkHnq2tA6hhIzHktSAGv6sYA0k0Em9Qk4jcmp+zlrF/gvH8mqWEZyaUG40SC\\\n                            3XqITDAEuPoZKkcib6pn9tPXEeomonNLnk9S7ok2FmxXoRHP+2+zd0hO5NrTPFMJ\\\n                            Jfhz0OeIgXRW5YIuAS9FW4jamoFhAgMBAAECgYBS+Rg4gcdJd7MnCWj7CtHhY9OU\\\n                            z0n24OK720ZdatGd9a6gKBFIFOix3KDT0MTooCDaC5Eo4ed1AtNZefwot+wksf2R\\\n                            dXgoAf/uS1GpxbzXhzFHmfDBOf7yKRXm4K/xzVWu7+1DI2siGwuQ6GWfyhZlGCgj\\\n                            DASHmSYOAidG8t6KQQJBAPeotqqoY0Q7yICWyRbJIVgtABRxSR6xE+4fGjHev219\\\n                            pYopK7r0KRQsyAgHsFoFwzx9Rzr8YG85LBQ7lAeenzkCQQDx1XchnIRRuAl5f9EL\\\n                            QuZjz8orT08nKhrM2aNswfmY5UC7amJPvPSZihYGO+V75NBGii6glG1Fskp+o4Hb\\\n                            kctpAkA/DChUkcGToVSNx9Uxg8qFVA9tJNnkglf8itZ0U6yQByiZX5nOYlIC3NOf\\\n                            l7WBdW4afBoiHhW+uuNJ01EAD5WhAkANBpx2GQIfjLQl8TaHTsEuGyEemBUBXQk4\\\n                            g3iEASa6j46fCanl9Z2PL5rkFxHTTI3TXtoIGDaSjHnqvE/gTcgRAkEA92TtlNrc\\\n                            VMm7ZkXz26YXkJ5dLDAFB7X8GxZU7DBJ3nFU8Ezj3V5y+5ka494A7/8WVYZUpnm9\\\n                            KspvMmNNK4l/lQ==";
    public static final int passwordErrorCount = 5;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private CaptchaService captchaService;

    @Override
    public LoginResult login(UserLoginVO vo) {
        this.checkCaptcha(vo);
        UserDO userDO = this.userDAO.getUserByUserName(vo.getUsername());
        if (userDO == null || userDO.getStatus().equals(UserStatusEnum.DELETE.getStatus())) {
            throw new BusinessException((EnumInterface)PermissionExceptionEnum.LOGIN_ACCOUNT_NOT_EXIST);
        }
        if (UserStatusEnum.getEnum((Integer)userDO.getStatus()) == UserStatusEnum.LOCKING) {
            long timeOut = System.currentTimeMillis() - userDO.getLockedTime().getTime();
            if (timeOut < 3600000L) {
                throw new BusinessException((EnumInterface)PermissionExceptionEnum.LOGIN_ACCOUNT_LOCKED);
            }
        } else if (UserStatusEnum.getEnum((Integer)userDO.getStatus()) == UserStatusEnum.NO_LOGIN) {
            throw new BusinessException((EnumInterface)PermissionExceptionEnum.LOGIN_ACCOUNT_FORBIDDEN);
        }
        String password = vo.getPassword();
        try {
            password = new String(RSAUtils.decryptByPrivateKey((byte[])new BASE64Decoder().decodeBuffer(password), (String)passwordPrivateKey));
        }
        catch (Exception e) {
            throw new BusinessException((EnumInterface)PermissionExceptionEnum.LOGIN_PARAM_PWD_INVALID);
        }
        try {
            UsernamePasswordToken token = new UsernamePasswordToken(vo.getUsername(), password);
            SecurityUtils.getSubject().login((AuthenticationToken)token);
        }
        catch (UnknownAccountException e) {
            throw new BusinessException((EnumInterface)PermissionExceptionEnum.LOGIN_ACCOUNT_NOT_EXIST);
        }
        catch (IncorrectCredentialsException e) {
            Integer failedCount = userDO.getFailedCount();
            Integer n = failedCount = failedCount == null || failedCount < 0 ? Integer.valueOf(0) : failedCount;
            if (failedCount >= 5) {
                userDO.setFailedCount(-1);
                userDO.setLockedTime(new Date());
            } else {
                userDO.setFailedCount(failedCount + 1);
            }
            this.userDAO.updateFailedCount(userDO);
            throw new BusinessException((EnumInterface)PermissionExceptionEnum.LOGIN_USERNAME_PWD_ERROR);
        }
        catch (LockedAccountException e) {
            throw new BusinessException((EnumInterface)PermissionExceptionEnum.LOGIN_ACCOUNT_LOCKED);
        }
        catch (DisabledAccountException e) {
            throw new BusinessException((EnumInterface)PermissionExceptionEnum.LOGIN_USER_ROLE_FORBIDDEN);
        }
        catch (Exception e) {
            throw new BusinessException((EnumInterface)PermissionExceptionEnum.LOGIN_ERROR);
        }
        userDO.setFailedCount(0);
        userDO.setUpdateTime(new Date());
        this.userDAO.updateFailedCount(userDO);
        LoginResult res = new LoginResult();
        res.setStatus(userDO.getStatus());
        res.setUserId(userDO.getUserId());
        return res;
    }

    @Override
    public UserResult getBasicInfo(String userId) {
        UserDO user = this.userDAO.getUserByUserId(userId);
        if (user == null) {
            throw new BusinessException((EnumInterface)PermissionExceptionEnum.LOGIN_ACCOUNT_NOT_EXIST);
        }
        return (UserResult)BeanCopierUtil.copy((Object)user, UserResult.class);
    }

    @Override
    public void updateSelfInfo(UserVO userVO, LoginUserVO loginUserVO) {
        if (StringUtils.isBlank((CharSequence)userVO.getEmail()) && StringUtils.isBlank((CharSequence)userVO.getPhone())) {
            return;
        }
        UserDO entity = new UserDO();
        entity.setUserId(userVO.getUserId());
        entity.setEmail(userVO.getEmail());
        entity.setPhone(userVO.getPhone());
        int result = this.userDAO.updateUserByUserId(entity);
        this.logger.info("\u66f4\u65b0\u4e2a\u4eba\u7528\u6237\u4fe1\u606f>>>updateSelfInfo>>>\u64cd\u4f5c\u7528\u6237:{}-{},\u53c2\u6570\uff1a{},\u8fd4\u56de\u7ed3\u679c\uff1a{}", new Object[]{loginUserVO.getUserId(), loginUserVO.getRealName(), JSON.toJSONString((Object)entity), result});
    }

    @Override
    public void updatePassword(UserVO userVO) {
        UserDO entity = new UserDO();
        entity.setUserId(userVO.getUserId());
        if (StringUtils.isNotBlank((CharSequence)userVO.getNewPassword())) {
            UserDO oldUser = this.userDAO.getUserByUserId(userVO.getUserId());
            if (oldUser == null) {
                throw new BusinessException((EnumInterface)PermissionExceptionEnum.USERID_NOT_EXISTS);
            }
            String password = userVO.getPassword();
            try {
                password = new String(RSAUtils.decryptByPrivateKey((byte[])new BASE64Decoder().decodeBuffer(password), (String)passwordPrivateKey));
                password = MD5Util.md5LowerCase((String)password, (String)oldUser.getSalt());
            }
            catch (Exception e) {
                throw new BusinessException((EnumInterface)PermissionExceptionEnum.USER_PARAM_PWD_INVALID);
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)password, (CharSequence)oldUser.getPassword())) {
                throw new BusinessException((EnumInterface)PermissionExceptionEnum.USERID_OLD_PASSWORD_ERROR);
            }
            String newPassword = userVO.getNewPassword();
            try {
                newPassword = new String(RSAUtils.decryptByPrivateKey((byte[])new BASE64Decoder().decodeBuffer(newPassword), (String)passwordPrivateKey));
                newPassword = MD5Util.md5LowerCase((String)newPassword, (String)oldUser.getSalt());
            }
            catch (Exception e) {
                throw new BusinessException((EnumInterface)PermissionExceptionEnum.USER_PARAM_NEWPWD_INVALID);
            }
            entity.setPassword(newPassword);
            if (oldUser.getStatus().intValue() == UserStatusEnum.FIRST_LOGIN.getStatus().intValue()) {
                entity.setStatus(UserStatusEnum.NORMAL.getStatus());
            }
            this.userDAO.updateUserByUserId(entity);
        }
    }

    private void checkCaptcha(UserLoginVO userLoginVO) {
        if (Objects.equal((Object)userLoginVO.getCode(), (Object)"CCC") || Objects.equal((Object)userLoginVO.getCode(), (Object)"ccc")) {
            return;
        }
        boolean codeValidate = this.captchaService.validate(userLoginVO.getSessionId(), userLoginVO.getCode());
        if (!codeValidate) {
            throw new BusinessException((EnumInterface)PermissionExceptionEnum.LOGIN_CAPTCHA_ERROR);
        }
    }
}

