/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.finance.business.service.admin.permission.impl;

import com.alibaba.fastjson.JSON;
import com.fshows.finance.business.dal.dao.GrantDAO;
import com.fshows.finance.business.dal.dao.RoleDAO;
import com.fshows.finance.business.dal.dao.RoleGrantDAO;
import com.fshows.finance.business.dal.dao.UserDAO;
import com.fshows.finance.business.dal.dataobject.RoleDO;
import com.fshows.finance.business.dal.dataobject.RoleGrantDO;
import com.fshows.finance.business.dal.dataobject.UserDO;
import com.fshows.finance.business.result.admin.permission.RoleResult;
import com.fshows.finance.business.service.admin.permission.RoleService;
import com.fshows.finance.business.vo.admin.permission.AddRoleVO;
import com.fshows.finance.business.vo.admin.permission.GrantVO;
import com.fshows.finance.business.vo.admin.permission.QueryRolePageListVO;
import com.fshows.finance.business.vo.admin.permission.UpdateRoleGrantVO;
import com.fshows.finance.business.vo.admin.permission.UpdateRoleInfoVO;
import com.fshows.finance.common.enums.permission.RoleStatusEnum;
import com.fshows.finance.common.exception.BusinessException;
import com.fshows.finance.common.exception.EnumInterface;
import com.fshows.finance.common.exception.permission.PermissionExceptionEnum;
import com.fshows.finance.common.model.base.BasePageModelResult;
import com.fshows.finance.common.tool.util.BeanCopierUtil;
import com.fshows.finance.common.tool.util.DateUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoleServiceImpl
implements RoleService {
    private static final Logger log = LoggerFactory.getLogger(RoleServiceImpl.class);
    @Resource
    private RoleDAO roleDAO;
    @Resource
    private RoleGrantDAO roleGrantDAO;
    @Resource
    private UserDAO userDAO;
    @Resource
    private GrantDAO grantDAO;

    @Override
    public BasePageModelResult queryRolePageList(QueryRolePageListVO vo) {
        log.info("\u89d2\u8272\u5206\u9875\u5217\u8868\u67e5\u8be2 >> queryRolePageList >> param={}", (Object)JSON.toJSONString((Object)vo));
        PageHelper.startPage((int)vo.getPage(), (int)vo.getPageSize());
        List<RoleDO> list = this.roleDAO.queryRolePageList(vo.getRoleName(), vo.getRoleId(), vo.getOrganizeId());
        List result = BeanCopierUtil.copyList(list, RoleResult.class);
        result.stream().forEach(param -> {
            param.setStatusDesc(RoleStatusEnum.getEnum((Integer)param.getStatus()).getDesc());
            param.setCreateTimeDesc(DateUtil.formatDateTime((Date)param.getCreateTime()));
        });
        PageInfo pageInfo = new PageInfo(result);
        return new BasePageModelResult(pageInfo.getPageNum(), pageInfo.getPageSize(), pageInfo.getTotal(), pageInfo.getList());
    }

    @Override
    @Transactional
    public void addRole(AddRoleVO vo) {
        RoleDO roleInfo = this.roleDAO.queryRoleByRoleName(vo.getRoleName());
        if (roleInfo != null) {
            throw new BusinessException((EnumInterface)PermissionExceptionEnum.ROLE_NAME_IS_EXIST);
        }
        ArrayList<Integer> grantIds = new ArrayList<Integer>();
        this.analyzeRecursion(vo.getGrantList(), grantIds);
        roleInfo = this.roleDAO.queryRoleByLast();
        int roleId = roleInfo.getRoleId() + 1;
        RoleDO roleParam = new RoleDO();
        roleParam.setRoleId(roleId);
        roleParam.setRoleName(vo.getRoleName());
        roleParam.setRoleDesc(vo.getRoleDesc());
        int result = this.roleDAO.insertSelective(roleParam);
        if (result == 0) {
            throw new BusinessException((EnumInterface)PermissionExceptionEnum.ROLE_ADD_FAILED);
        }
        this.getGrantByPublicAndAttach(grantIds);
        LinkedList<RoleGrantDO> list = new LinkedList<RoleGrantDO>();
        grantIds.stream().forEach(grantId -> {
            RoleGrantDO param = new RoleGrantDO();
            param.setRoleId(roleId);
            param.setGrantId((Integer)grantId);
            list.add(param);
        });
        this.roleGrantDAO.batchInsert(list);
    }

    @Override
    public void delRole(Integer roleId) {
        List<UserDO> userList = this.userDAO.getUserByRoleId(roleId);
        if (CollectionUtils.isNotEmpty(userList)) {
            throw new BusinessException((EnumInterface)PermissionExceptionEnum.ROLE_IS_USED);
        }
        RoleDO role = new RoleDO();
        role.setRoleId(roleId);
        role.setStatus(RoleStatusEnum.DELETE.getStatus());
        int result = this.roleDAO.updateSelective(role);
        if (result == 0) {
            throw new BusinessException((EnumInterface)PermissionExceptionEnum.ROLE_UPDATE_FAILED);
        }
    }

    @Override
    public void updateRoleInfo(UpdateRoleInfoVO vo) {
        RoleDO roleInfo = this.roleDAO.queryRoleByRoleName(vo.getRoleName());
        if (roleInfo != null) {
            throw new BusinessException((EnumInterface)PermissionExceptionEnum.ROLE_NAME_IS_EXIST);
        }
        RoleDO role = (RoleDO)BeanCopierUtil.copy((Object)vo, RoleDO.class);
        int result = this.roleDAO.updateSelective(role);
        if (result == 0) {
            throw new BusinessException((EnumInterface)PermissionExceptionEnum.ROLE_UPDATE_FAILED);
        }
    }

    @Override
    @Transactional
    public void updateRoleGrant(UpdateRoleGrantVO vo) {
        ArrayList<Integer> grantIds = new ArrayList<Integer>();
        this.analyzeRecursion(vo.getGrantList(), grantIds);
        this.getGrantByPublicAndAttach(grantIds);
        LinkedList<RoleGrantDO> list = new LinkedList<RoleGrantDO>();
        grantIds.stream().forEach(grantId -> {
            RoleGrantDO param = new RoleGrantDO();
            param.setRoleId(vo.getRoleId());
            param.setGrantId((Integer)grantId);
            list.add(param);
        });
        int result = this.roleGrantDAO.deleteByRoleId(vo.getRoleId());
        if (result == 0) {
            throw new BusinessException((EnumInterface)PermissionExceptionEnum.ROLE_GRANT_DELETE_FAILED);
        }
        this.roleGrantDAO.batchInsert(list);
    }

    private void getGrantByPublicAndAttach(List<Integer> grantIds) {
        List<Integer> attachIds = this.grantDAO.getGrantIdsByAttach();
        attachIds.retainAll(grantIds);
        if (attachIds.size() > 0) {
            List<Integer> attachGrantList = this.grantDAO.getAttachGrantByParentId(attachIds);
            grantIds.addAll(attachGrantList);
        }
        List<Integer> publicGrantList = this.grantDAO.getGrantPublic();
        grantIds.addAll(publicGrantList);
    }

    private void analyzeRecursion(List<GrantVO> param, List<Integer> grantIds) {
        param.stream().forEach(menu -> {
            if (menu.getIsHavePemission() == 1) {
                grantIds.add(menu.getGrantId());
                if (menu.getMenuSubList() != null) {
                    this.analyzeRecursion(menu.getMenuSubList(), grantIds);
                }
                if (menu.getFunctionSubList() != null) {
                    menu.getFunctionSubList().stream().forEach(function -> {
                        if (function.getIsHavePemission() == 1) {
                            grantIds.add(function.getGrantId());
                        }
                    });
                }
            }
        });
    }
}

