/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.finance.business.service.admin.permission.impl;

import com.alibaba.fastjson.JSON;
import com.fshows.finance.business.dal.dao.GrantDAO;
import com.fshows.finance.business.dal.dao.RoleGrantDAO;
import com.fshows.finance.business.dal.dataobject.GrantDO;
import com.fshows.finance.business.dal.dataobject.RoleGrantDO;
import com.fshows.finance.business.result.admin.permission.GrantResult;
import com.fshows.finance.business.result.admin.permission.LoginedGrantResult;
import com.fshows.finance.business.service.admin.permission.GrantService;
import com.fshows.finance.common.tool.util.BeanCopierUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class GrantServiceImpl
implements GrantService {
    @Resource
    private GrantDAO grantDAO;
    @Resource
    private RoleGrantDAO roleGrantDAO;

    @Override
    public LoginedGrantResult loginedGrant(Integer roleId, Integer type) {
        Long begin = System.currentTimeMillis();
        List<RoleGrantDO> roleGrantList = this.roleGrantDAO.getGrantByRoleId(roleId);
        LinkedList<Integer> paramList = new LinkedList<Integer>();
        roleGrantList.stream().forEach(roleGrant -> paramList.add(roleGrant.getGrantId()));
        List<GrantDO> grantList = type == 1 ? this.grantDAO.getGrantExceptPublic(paramList) : this.grantDAO.getGrantByGrantIds(paramList);
        System.out.println("#####:" + JSON.toJSONString(grantList));
        List<GrantResult> resultList = this.grantRecursion(null, grantList);
        System.out.println("####resultList:" + JSON.toJSONString(resultList) + ",usetime:" + (System.currentTimeMillis() - begin));
        LoginedGrantResult result = new LoginedGrantResult();
        result.setRoleId(roleId);
        result.setGrantList(resultList);
        return result;
    }

    @Override
    public LoginedGrantResult getGrantByRoleId(Integer roleId) {
        List<RoleGrantDO> roleGrantList = this.roleGrantDAO.getGrantByRoleId(roleId);
        LinkedList<Integer> paramList = new LinkedList<Integer>();
        roleGrantList.stream().forEach(roleGrant -> paramList.add(roleGrant.getGrantId()));
        List<GrantDO> grantList = this.grantDAO.getGrantExceptPublic(paramList);
        List<GrantResult> resultList = this.grantRecursion(null, grantList);
        LoginedGrantResult result = new LoginedGrantResult();
        result.setRoleId(roleId);
        result.setGrantList(resultList);
        return result;
    }

    private List<GrantResult> grantRecursion(GrantDO vo, List<GrantDO> list) {
        ArrayList<GrantResult> resultList = new ArrayList<GrantResult>();
        list.stream().filter(e -> (vo == null ? 0 : vo.getGrantId()) == e.getGrantParentId()).forEach(grant -> {
            GrantResult grantResult = (GrantResult)BeanCopierUtil.copy((Object)grant, GrantResult.class);
            grantResult.setName(grant.getGrantName());
            List<GrantResult> result = this.grantRecursion((GrantDO)grant, list);
            if (result.size() != 0) {
                if ("M".equals(result.get(0).getGrantType())) {
                    grantResult.setMenuSubList(result);
                } else {
                    grantResult.setFunctionSubList(result);
                }
            }
            resultList.add(grantResult);
        });
        return resultList;
    }
}

