/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.finance.business.service.admin.permission.impl;

import com.fshows.finance.business.service.admin.permission.CaptchaService;
import com.fshows.finance.common.constant.RedisConstants;
import com.fshows.finance.common.redis.RedisCache;
import com.google.code.kaptcha.Producer;
import java.awt.image.BufferedImage;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CaptchaServiceImpl
implements CaptchaService {
    private final Logger logger = LoggerFactory.getLogger(CaptchaServiceImpl.class);
    @Autowired
    private Producer producer;
    @Autowired
    private RedisCache redisCache;

    @Override
    public BufferedImage getCaptcha(String sessionId) {
        String code = this.producer.createText();
        this.redisCache.setNx(RedisConstants.LOGIN_CAPTCHA_CODE + sessionId, (Object)code, RedisConstants.LOGIN_CAPTCHA_CODE_SECONDS);
        return this.producer.createImage(code);
    }

    @Override
    public boolean validate(String sessionId, String code) {
        String key = RedisConstants.LOGIN_CAPTCHA_CODE + sessionId;
        String cachedCode = this.redisCache.get(key);
        if (StringUtils.isBlank((String)cachedCode)) {
            return false;
        }
        this.redisCache.del(key);
        return StringUtils.equals((String)code, (String)cachedCode);
    }
}

