/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.finance.business.service.admin.config.impl;

import com.alibaba.fastjson.JSON;
import com.fshows.finance.business.dal.dao.BaseConfigDAO;
import com.fshows.finance.business.dal.dao.ProjectFeeCodeDAO;
import com.fshows.finance.business.dal.dataobject.BaseConfigDO;
import com.fshows.finance.business.dal.dataobject.ProjectFeeCodeDO;
import com.fshows.finance.business.result.admin.config.FeeSelectListResult;
import com.fshows.finance.business.result.admin.config.SelectListResult;
import com.fshows.finance.business.service.admin.config.SelectListService;
import com.fshows.finance.business.vo.admin.config.FeeSelectListVO;
import com.fshows.finance.business.vo.admin.config.SelectListVO;
import com.fshows.finance.common.constant.NumberConstant;
import com.fshows.finance.common.exception.BaseConfigEnum;
import com.fshows.finance.common.exception.BusinessException;
import com.fshows.finance.common.exception.EnumInterface;
import com.fshows.finance.common.redis.RedisCache;
import com.fshows.finance.common.tool.util.BeanCopierUtil;
import com.fshows.finance.common.tool.util.ListUtils;
import com.fshows.finance.common.tool.util.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SelectListServiceImpl
implements SelectListService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectListServiceImpl.class);
    @Resource
    RedisCache redisCache;
    @Autowired
    private BaseConfigDAO baseConfigDAO;
    @Autowired
    private ProjectFeeCodeDAO projectFeeCodeDAO;

    @Override
    public List<SelectListResult> getSelectList(SelectListVO selectListVO) {
        Boolean existsFlag = this.redisCache.exists("select.list.config");
        LOGGER.info("\u7f13\u5b58\u4e2d\u662f\u5426\u5b58\u5728 existsFlag={}", (Object)existsFlag);
        List<BaseConfigDO> baseConfigDOList = existsFlag != false ? this.getBaseNameByCache(selectListVO.getType()) : this.getFormDBAndFlushCache(selectListVO.getType());
        LOGGER.info("\u914d\u7f6e\u9879\u7c7b\u578b:{},\u914d\u7f6e\u9879\u4e0b\u62c9\u5217\u8868\u6570\u91cf:{}", (Object)selectListVO.getType(), (Object)baseConfigDOList.size());
        return BeanCopierUtil.copyList(baseConfigDOList, SelectListResult.class);
    }

    @Override
    public void flushCache() {
        this.redisCache.del("select.list.config");
        List<BaseConfigDO> baseConfigDOList = this.baseConfigDAO.getAll();
        LOGGER.info("SelectListServiceImpl >>> flushCache \u6570\u636e\u5e93\u83b7\u53d6\u7684\u914d\u7f6e\u9879\u96c6\u5408\u957f\u5ea6:{}", (Object)baseConfigDOList.size());
        if (ListUtils.isEmpty(baseConfigDOList)) {
            throw new BusinessException((EnumInterface)BaseConfigEnum.BASE_CONFIG_IS_EMPTY);
        }
        HashMap map = Maps.newHashMap();
        for (BaseConfigDO baseConfigDO : baseConfigDOList) {
            if (map.containsKey(baseConfigDO.getType())) {
                ((List)map.get(baseConfigDO.getType())).add(baseConfigDO);
                continue;
            }
            ArrayList newList = Lists.newArrayList();
            newList.add(baseConfigDO);
            map.put(baseConfigDO.getType(), newList);
        }
        for (Map.Entry entry : map.entrySet()) {
            Boolean aBoolean = this.redisCache.hSetNx("select.list.config", (String)entry.getKey(), entry.getValue());
            LOGGER.info("\u5c06{}\u66f4\u65b0\u5230\u7f13\u5b58\uff0c\u66f4\u65b0\u7ed3\u679c{}", entry.getKey(), (Object)aBoolean);
        }
    }

    @Override
    public List<FeeSelectListResult> getSelectList(FeeSelectListVO feeSelectListVO) {
        List feeSelectListResultList = Lists.newArrayList();
        Integer projectCategoryCode = feeSelectListVO.getProjectCategoryCode();
        if (NumberConstant.NEGATIVEONE.equals(projectCategoryCode)) {
            FeeSelectListResult feeSelectListResult = new FeeSelectListResult();
            feeSelectListResult.setFeeCode(NumberConstant.NEGATIVEONE.toString());
            feeSelectListResult.setFeeProjectName("\u5168\u90e8");
            feeSelectListResultList.add(feeSelectListResult);
            return feeSelectListResultList;
        }
        List<ProjectFeeCodeDO> projectFeeCodeDOList = this.projectFeeCodeDAO.getFeeProjectNameByCode(projectCategoryCode);
        LOGGER.info("SelectListServiceImpl >>> getSelectList \u6570\u636e\u5e93\u4e2d\u9879\u76ee\u5206\u7c7b\u96c6\u5408\u957f\u5ea6:{}", (Object)projectFeeCodeDOList.size());
        feeSelectListResultList = BeanCopierUtil.copyList(projectFeeCodeDOList, FeeSelectListResult.class);
        return feeSelectListResultList;
    }

    private List<BaseConfigDO> getBaseNameByCache(String type) {
        String selectCacheJson = (String)this.redisCache.hGet("select.list.config", type, String.class);
        LOGGER.info("SelectListServiceImpl >>> getBaseNameBycache \u7f13\u5b58\u4e2d\u516c\u5171\u914d\u7f6e\u9879:{}", (Object)selectCacheJson);
        if (StringUtils.isNotEmpty((String)selectCacheJson)) {
            LOGGER.info("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6");
            return JSON.parseArray((String)selectCacheJson, BaseConfigDO.class);
        }
        return null;
    }

    private List<BaseConfigDO> getFormDBAndFlushCache(String type) {
        List<BaseConfigDO> baseConfigDOList = this.baseConfigDAO.getBaseNameByType(type);
        if (ListUtils.isEmpty(baseConfigDOList)) {
            LOGGER.info("\u4e1a\u52a1\u7c7b\u578b\u5bf9\u5e94\u7684\u914d\u7f6e\u8868\u6570\u636e\u4e3a\u7a7a");
            return Lists.newArrayList();
        }
        LOGGER.info("\u4ecedb\u4e2d\u83b7\u53d6");
        Boolean aBoolean = this.redisCache.hSetNx("select.list.config", type, baseConfigDOList);
        LOGGER.info("\u66f4\u65b0\u7f13\u5b58\u72b6\u6001:{}", (Object)aBoolean);
        return baseConfigDOList;
    }
}

