/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.common.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dozer.DozerBeanMapperBuilder;
import org.dozer.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FsBeanUtil {
    private static final Mapper MAPPER = DozerBeanMapperBuilder.buildDefault();
    private static final Logger LOGGER = LoggerFactory.getLogger(FsBeanUtil.class);

    public static <T> T map(Object source, Class<T> destinationClass) {
        return (T)MAPPER.map(source, destinationClass);
    }

    public static <T> List<T> mapList(Collection sourceList, Class<T> destinationClass) {
        if (null == sourceList || sourceList.size() == 0) {
            return new ArrayList();
        }
        ArrayList destinationList = Lists.newArrayList();
        for (Object sourceObject : sourceList) {
            Object destinationObject = MAPPER.map(sourceObject, destinationClass);
            destinationList.add(destinationObject);
        }
        return destinationList;
    }

    public static void copy(Object source, Object destinationObject) {
        MAPPER.map(source, destinationObject);
    }

    static {
        MAPPER.map(new Object(), new Object());
    }
}

