/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.common.util.idgen.impl;

import com.fshows.common.util.DateUtil;
import com.fshows.common.util.SystemClock;
import com.fshows.common.util.idgen.BitsAllocator;
import com.fshows.common.util.idgen.FsIdGenerator;
import com.fshows.common.util.idgen.exception.IdGenerateException;
import com.fshows.common.util.idgen.worker.WorkerIdAssigner;
import java.text.MessageFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultIdGenerator
implements FsIdGenerator,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultIdGenerator.class);
    protected short timeBits = (short)40;
    protected short workerBits = (short)12;
    protected short seqBits = (short)11;
    protected String epochStr = "2018-01-01";
    protected long epochSeconds = 1514736000000L;
    protected BitsAllocator bitsAllocator;
    protected long workerId;
    protected long sequence = 0L;
    protected long lastSecond = -1L;
    protected short sequenceLength = (short)4;
    protected short workerIdLength = (short)4;
    protected short customerDataLength = (short)5;
    @Autowired
    private WorkerIdAssigner workerIdAssigner;

    @Override
    public Long getId() throws IdGenerateException {
        try {
            return this.nextId();
        }
        catch (Exception e) {
            LOGGER.error("Generate unique id exception. ", (Throwable)e);
            throw new IdGenerateException(e);
        }
    }

    @Override
    public String parseId(long id) {
        long totalBits = 64L;
        long signBits = this.bitsAllocator.getSignBits();
        long timestampBits = this.bitsAllocator.getTimestampBits();
        long workerIdBits = this.bitsAllocator.getWorkerIdBits();
        long sequenceBits = this.bitsAllocator.getSequenceBits();
        long sequence = id << (int)(totalBits - sequenceBits) >>> (int)(totalBits - sequenceBits);
        long workerId = id << (int)(timestampBits + signBits) >>> (int)(totalBits - workerIdBits);
        long deltaSeconds = id >>> (int)(workerIdBits + sequenceBits);
        Date thatTime = new Date(this.epochSeconds + deltaSeconds);
        String thatTimeStr = DateUtil.format(thatTime, "yyyy-MM-dd HH:mm:ss");
        return String.format("{\"ID\":\"%d\",\"timestamp\":\"%s\",\"workerId\":\"%d\",\"sequence\":\"%d\"}", id, thatTimeStr, workerId, sequence);
    }

    @Override
    public String getStrId(String exData) throws IdGenerateException {
        try {
            return this.nextStrId(exData);
        }
        catch (Exception e) {
            LOGGER.error("Generate unique id exception. ", (Throwable)e);
            throw new IdGenerateException(e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.bitsAllocator = new BitsAllocator(this.timeBits, this.workerBits, this.seqBits);
        this.workerId = this.workerIdAssigner.assignWorkerId();
        LOGGER.info("worker id is {}", (Object)this.workerId);
        if (this.workerId > this.bitsAllocator.getMaxWorkerId()) {
            throw new IdGenerateException(MessageFormat.format("worker id is illegal,workerid={0},max workerId={1}", this.workerId, this.bitsAllocator.getMaxWorkerId()));
        }
        LOGGER.info("init bits(1,{},{},{})", new Object[]{this.timeBits, this.workerBits, this.seqBits});
    }

    private synchronized Long nextId() {
        long currentMillSeconds = this.getCurrentMillSeconds();
        if (currentMillSeconds < this.lastSecond) {
            long refusedSeconds = this.lastSecond - currentMillSeconds;
            throw new IdGenerateException("Clock moved backwards. Refusing for %d seconds", refusedSeconds);
        }
        if (currentMillSeconds == this.lastSecond) {
            this.sequence = this.sequence + 1L & this.bitsAllocator.getMaxSequence();
            if (this.sequence == 0L) {
                currentMillSeconds = this.getNextMillSeconds(this.lastSecond);
            }
        } else {
            this.sequence = RandomUtils.nextLong((long)0L, (long)9L);
        }
        this.lastSecond = currentMillSeconds;
        return this.bitsAllocator.allocate(currentMillSeconds - this.epochSeconds, this.workerId, this.sequence);
    }

    private synchronized String nextStrId(String exData) {
        if (StringUtils.isBlank((CharSequence)exData) || exData.length() != this.customerDataLength) {
            throw new IllegalArgumentException("exData's length must be 4");
        }
        long currentMillSeconds = this.getCurrentMillSeconds();
        if (currentMillSeconds < this.lastSecond) {
            long refusedSeconds = this.lastSecond - currentMillSeconds;
            throw new IdGenerateException("Clock moved backwards. Refusing for %d seconds", refusedSeconds);
        }
        if (currentMillSeconds == this.lastSecond) {
            this.sequence = this.sequence + 1L & this.bitsAllocator.getMaxSequence();
            if (this.sequence == 0L) {
                currentMillSeconds = this.getNextMillSeconds(this.lastSecond);
            }
        } else {
            this.sequence = RandomUtils.nextLong((long)0L, (long)9L);
        }
        this.lastSecond = currentMillSeconds;
        return DateFormatUtils.format((long)currentMillSeconds, (String)"yyyyMMddHHmmssSSS") + exData + StringUtils.leftPad((String)String.valueOf(this.workerId), (int)this.workerIdLength, (char)'0') + StringUtils.leftPad((String)String.valueOf(this.sequence), (int)this.sequenceLength, (char)'0');
    }

    private long getCurrentMillSeconds() {
        long currentSecond = SystemClock.millisClock().now();
        if (currentSecond - this.epochSeconds > this.bitsAllocator.getMaxDeltaSeconds()) {
            throw new IdGenerateException("Timestamp bits is exhausted. Refusing UID generate. Now: " + currentSecond);
        }
        return currentSecond;
    }

    private long getNextMillSeconds(long lastTimestamp) {
        long timestamp = this.getCurrentMillSeconds();
        while (timestamp <= lastTimestamp) {
            timestamp = this.getCurrentMillSeconds();
        }
        return timestamp;
    }

    public void setWorkerIdAssigner(WorkerIdAssigner workerIdAssigner) {
        this.workerIdAssigner = workerIdAssigner;
    }

    public void setTimeBits(short timeBits) {
        this.timeBits = timeBits;
    }

    public void setWorkerBits(short workerBits) {
        this.workerBits = workerBits;
    }

    public void setSeqBits(short seqBits) {
        this.seqBits = seqBits;
    }

    public void setEpochStr(String epochStr) {
        if (StringUtils.isNotBlank((CharSequence)epochStr)) {
            Date epochDate;
            this.epochStr = epochStr;
            try {
                epochDate = DateUtil.parseDate(epochStr, "yyyy-MM-dd");
            }
            catch (Exception ex) {
                epochDate = new Date();
                LOGGER.error("epochstr date format error it must be yyyy-MM-dd", (Throwable)ex);
            }
            this.epochSeconds = TimeUnit.MILLISECONDS.toSeconds(epochDate.getTime());
        }
    }

    public void setSequenceLength(short sequenceLength) {
        this.sequenceLength = sequenceLength;
    }

    public void setWorkerIdLength(short workerIdLength) {
        this.workerIdLength = workerIdLength;
    }

    public void setCustomerDataLength(short customerDataLength) {
        this.customerDataLength = customerDataLength;
    }
}

