/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.common.admin.service.util;

import com.fshows.common.admin.facade.result.AdminMenuResult;
import com.fshows.common.admin.facade.result.FunctionMenuResult;
import com.fshows.common.admin.service.dal.welfare.dataobject.CommonModuleDO;
import com.fshows.common.util.FsBeanUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleModuleUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoleModuleUtil.class);

    public static List<AdminMenuResult> assembleModules(List<CommonModuleDO> moduleList, List<CommonModuleDO> allModules) {
        ArrayList resultList = Lists.newArrayList();
        if (moduleList == null || allModules == null) {
            return resultList;
        }
        AdminMenuResult homeMenuModel = new AdminMenuResult("\u9996\u9875", 1, "0", "home", "/");
        resultList.add(homeMenuModel);
        ArrayList parentModules = Lists.newArrayList();
        for (CommonModuleDO moduleDO : allModules) {
            if (moduleDO.getModuleLevel() != 1) continue;
            parentModules.add(moduleDO);
        }
        for (CommonModuleDO parentModule : parentModules) {
            AdminMenuResult adminMenuModel = (AdminMenuResult)FsBeanUtil.map((Object)parentModule, AdminMenuResult.class);
            if (RoleModuleUtil.dealSelect(adminMenuModel.getModuleId(), moduleList)) {
                adminMenuModel.setIsHavePermission(1);
            }
            ArrayList functionMenuModels = Lists.newArrayList();
            for (CommonModuleDO childModule : allModules) {
                if (childModule.getModuleLevel() != 2) continue;
                FunctionMenuResult functionMenuModel = (FunctionMenuResult)FsBeanUtil.map((Object)childModule, FunctionMenuResult.class);
                if (RoleModuleUtil.dealSelect(childModule.getModuleId(), moduleList)) {
                    functionMenuModel.setIsHavePermission(1);
                }
                if (!StringUtils.equals((CharSequence)parentModule.getModuleId(), (CharSequence)childModule.getModulePid())) continue;
                functionMenuModels.add(functionMenuModel);
            }
            adminMenuModel.setFunctionMenuModels((List)functionMenuModels);
            resultList.add(adminMenuModel);
        }
        LOGGER.info("assembleModules size={}", (Object)resultList.size());
        return resultList;
    }

    private static boolean dealSelect(String moduleId, List<CommonModuleDO> moduleList) {
        if (CollectionUtils.isEmpty(moduleList)) {
            return false;
        }
        for (CommonModuleDO moduleDO : moduleList) {
            if (!moduleId.equals(moduleDO.getModuleId())) continue;
            return true;
        }
        return false;
    }
}

