/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.common.admin.service.impl;

import com.fshows.common.admin.facade.model.AdminAddOrUpdateModel;
import com.fshows.common.admin.facade.model.AdminLoginModel;
import com.fshows.common.admin.facade.model.AdminModel;
import com.fshows.common.admin.facade.result.AdminListResult;
import com.fshows.common.admin.facade.result.AdminMenuResult;
import com.fshows.common.admin.service.AdminService;
import com.fshows.common.admin.service.dal.welfare.dao.CommonAdminDAO;
import com.fshows.common.admin.service.dal.welfare.dao.CommonRoleDAO;
import com.fshows.common.admin.service.dal.welfare.dataobject.CommonAdminDO;
import com.fshows.common.admin.service.dal.welfare.dataobject.CommonModuleDO;
import com.fshows.common.admin.service.dal.welfare.paging.AdminListModelPage;
import com.fshows.common.admin.service.enums.EnableStatusEnum;
import com.fshows.common.admin.service.exception.AdminException;
import com.fshows.common.admin.service.util.RoleModuleUtil;
import com.fshows.common.util.FsBeanUtil;
import com.fshows.common.util.idgen.FsIdGenerator;
import com.fshows.common.util.model.BasePageModel;
import com.fshows.common.util.result.BasePageResult;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="adminService")
public class AdminServiceImpl
implements AdminService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdminServiceImpl.class);
    @Autowired
    private FsIdGenerator fsIdGenerator;
    @Autowired
    private CommonAdminDAO adminDao;
    @Autowired
    private CommonRoleDAO roleDao;

    public AdminLoginModel login(String adminName, String password) {
        AdminLoginModel adminLoginModel = new AdminLoginModel();
        AdminModel adminModel = this.getByAccountName(adminName);
        if (adminModel == null) {
            adminLoginModel.setMessage("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u7528\u6237\u540d\u6216\u5bc6\u7801");
            return adminLoginModel;
        }
        if (!StringUtils.equals((CharSequence)password, (CharSequence)adminModel.getPassword())) {
            adminLoginModel.setMessage("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u7528\u6237\u540d\u6216\u5bc6\u7801");
            return adminLoginModel;
        }
        adminLoginModel.setResult(true);
        adminLoginModel.setMessage("\u767b\u5f55\u6210\u529f");
        adminLoginModel.setAdminModel(adminModel);
        LOGGER.info("login success, adminName={}", (Object)adminName);
        return adminLoginModel;
    }

    public AdminModel getByAccountName(String adminName) {
        if (StringUtils.isBlank((CharSequence)adminName)) {
            return null;
        }
        CommonAdminDO adminDO = this.adminDao.getByAdminName(adminName);
        if (adminDO == null) {
            return null;
        }
        return (AdminModel)FsBeanUtil.map((Object)adminDO, AdminModel.class);
    }

    public Boolean checkAdminName(String adminId, String adminName) {
        Integer count = this.adminDao.checkAdminName(adminId, adminName);
        return count > 0;
    }

    public Boolean addAdmin(AdminAddOrUpdateModel adminAddModel) {
        if (this.checkAdminName(null, adminAddModel.getAdminUsername()).booleanValue()) {
            throw AdminException.ADMIN_EXISTS_EXCEPTION;
        }
        CommonAdminDO adminDo = (CommonAdminDO)FsBeanUtil.map((Object)adminAddModel, CommonAdminDO.class);
        adminDo.setAdminId(this.fsIdGenerator.getStrId("00001"));
        adminDo.setAdminEnableFlag(Integer.valueOf(EnableStatusEnum.ENABLE.getValue()));
        this.adminDao.addAdmin(adminDo);
        return true;
    }

    public Boolean updateAdmin(AdminAddOrUpdateModel adminUpdateModel) {
        if (this.checkAdminName(adminUpdateModel.getAdminId(), adminUpdateModel.getAdminUsername()).booleanValue()) {
            throw AdminException.ADMIN_EXISTS_EXCEPTION;
        }
        CommonAdminDO adminDo = (CommonAdminDO)FsBeanUtil.map((Object)adminUpdateModel, CommonAdminDO.class);
        this.adminDao.updateAdmin(adminDo);
        return true;
    }

    public Boolean deleteAdmin(String adminId) {
        this.adminDao.deleteAdmin(adminId);
        return true;
    }

    public List<AdminMenuResult> getAdminMenuModel(String roleId) {
        if (StringUtils.isBlank((CharSequence)roleId)) {
            return Lists.newArrayList();
        }
        List<CommonModuleDO> moduleList = this.roleDao.getModulesByRoleId(roleId);
        List<CommonModuleDO> allModules = this.roleDao.getAllModules();
        LOGGER.info("getAdminMenuModel moduleSize={}, allModuleSize={}", (Object)moduleList.size(), (Object)allModules.size());
        List<AdminMenuResult> resultList = RoleModuleUtil.assembleModules(moduleList, allModules);
        return resultList;
    }

    public BasePageResult<AdminListResult> getAdminList(BasePageModel basePageModel) {
        AdminListModelPage adminListModelPage = new AdminListModelPage();
        adminListModelPage.setCurrPageNo(basePageModel.getPage());
        adminListModelPage.setLimit(basePageModel.getPageSize());
        adminListModelPage = this.adminDao.getAdminList(adminListModelPage);
        int count = adminListModelPage.getTotal();
        List adminDOs = adminListModelPage.getDatas();
        LOGGER.info("resultList={}", adminDOs);
        List resultList = FsBeanUtil.mapList(adminDOs, AdminListResult.class);
        LOGGER.info("resultList={}", (Object)resultList);
        BasePageResult basePageResult = new BasePageResult(count, resultList);
        return basePageResult;
    }

    public List<AdminListResult> getAdminListByName(String adminName) {
        List<CommonAdminDO> adminDOs = this.adminDao.getAdminByName(adminName);
        List list = FsBeanUtil.mapList(adminDOs, AdminListResult.class);
        return list;
    }
}

