/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.common.admin.service.dal.common.paging;

import java.util.List;

public class BasePage<T> {
    private List<T> datas;
    private int total = 0;
    private int limit = 20;
    private int pageNos = 1;
    private int currPageNo = 1;
    private boolean isFirstPage = false;
    private boolean isLastPage = false;
    private boolean hasPreviousPage = false;
    private boolean hasNextPage = false;
    private int navigatePages = 8;
    private int[] navigatePageNos;

    private void init() {
        this.pageNos = (this.total - 1) / this.limit + 1;
        this.currPageNo = this.currPageNo < 1 ? 1 : (this.currPageNo > this.pageNos ? this.pageNos : this.currPageNo);
        this.calcNavigatePageNumbers();
        this.judgePageBoudary();
    }

    private void calcNavigatePageNumbers() {
        if (this.pageNos <= this.navigatePages) {
            this.navigatePageNos = new int[this.pageNos];
            for (int i = 0; i < this.pageNos; ++i) {
                this.navigatePageNos[i] = i + 1;
            }
        } else {
            this.navigatePageNos = new int[this.navigatePages];
            int startNum = this.currPageNo - this.navigatePages / 2;
            int endNum = this.currPageNo + this.navigatePages / 2;
            if (startNum < 1) {
                startNum = 1;
                for (int i = 0; i < this.navigatePages; ++i) {
                    this.navigatePageNos[i] = startNum++;
                }
            } else if (endNum > this.pageNos) {
                endNum = this.pageNos;
                for (int i = this.navigatePages - 1; i >= 0; --i) {
                    this.navigatePageNos[i] = endNum--;
                }
            } else {
                for (int i = 0; i < this.navigatePages; ++i) {
                    this.navigatePageNos[i] = startNum++;
                }
            }
        }
    }

    private void judgePageBoudary() {
        this.isFirstPage = this.currPageNo == 1;
        this.isLastPage = this.currPageNo == this.pageNos && this.currPageNo != 1;
        this.hasPreviousPage = this.currPageNo > 1;
        this.hasNextPage = this.currPageNo < this.pageNos;
    }

    public List<T> getDatas() {
        return this.datas;
    }

    public void setDatas(List<T> datas) {
        this.datas = datas;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
        this.init();
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setNavigatePages(int navigatePages) {
        this.navigatePages = navigatePages;
    }

    public int getPageNos() {
        return this.pageNos;
    }

    public int getCurrPageNo() {
        return this.currPageNo;
    }

    public int[] getNavigatePageNos() {
        return this.navigatePageNos;
    }

    public boolean isFirstPage() {
        return this.isFirstPage;
    }

    public boolean isLastPage() {
        return this.isLastPage;
    }

    public boolean hasPreviousPage() {
        return this.hasPreviousPage;
    }

    public boolean hasNextPage() {
        return this.hasNextPage;
    }

    public void setCurrPageNo(int currPageNo) {
        this.currPageNo = currPageNo == 0 ? 1 : currPageNo;
    }

    public int getStartRow() {
        return (this.currPageNo - 1) * this.limit;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[").append("total=").append(this.total).append(",pageNos=").append(this.pageNos).append(",currPageNo=").append(this.currPageNo).append(",limit=").append(this.limit).append(",isFirstPage=").append(this.isFirstPage).append(",isLastPage=").append(this.isLastPage).append(",hasPreviousPage=").append(this.hasPreviousPage).append(",hasNextPage=").append(this.hasNextPage).append(",navigatePageNos=");
        int len = this.navigatePageNos.length;
        if (len > 0) {
            sb.append(this.navigatePageNos[0]);
        }
        for (int i = 1; i < len; ++i) {
            sb.append(" " + this.navigatePageNos[i]);
        }
        sb.append(",datas.size=" + this.datas.size());
        sb.append("]");
        return sb.toString();
    }
}

