/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.web.sign;

import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.web.exception.ApiInvokeException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SignChecker.class);

    public static boolean rsaCheck(Map<String, String> params, String publicKey, String charset) {
        String sign = params.get("sign");
        String content = SignChecker.getSignCheckContent(params);
        return SignChecker.rsa256CheckContent(content, sign, publicKey, charset);
    }

    public static String rsaSign(Map<String, String> params, String privateKey, String charset) {
        String content = SignChecker.getSignCheckContent(params);
        return SignChecker.rsa256Sign(content, privateKey, charset);
    }

    private static String rsa256Sign(String content, String privateKey, String charset) {
        try {
            PrivateKey priKey = SignChecker.getPrivateKeyFromPKCS8("RSA", new ByteArrayInputStream(privateKey.getBytes()));
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initSign(priKey);
            if (StringUtils.isEmpty((CharSequence)charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            byte[] signed = signature.sign();
            return new String(Base64.encodeBase64((byte[])signed));
        }
        catch (Exception ex) {
            LogUtil.error((Logger)log, (String)("RSAcontent = " + content + "; charset = " + charset), (Throwable)ex);
            throw ApiInvokeException.API_INVALID_SIGIN;
        }
    }

    private static PrivateKey getPrivateKeyFromPKCS8(String algorithm, InputStream ins) throws Exception {
        if (ins != null && !StringUtils.isEmpty((CharSequence)algorithm)) {
            KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
            byte[] encodedKey = SignChecker.readText(ins).getBytes();
            encodedKey = Base64.decodeBase64((byte[])encodedKey);
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
        }
        return null;
    }

    private static String getSignCheckContent(Map<String, String> params) {
        if (params == null) {
            return null;
        }
        params.remove("sign");
        StringBuilder content = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            content.append(i == 0 ? "" : "&").append(key).append("=").append(value);
        }
        return content.toString();
    }

    private static boolean rsa256CheckContent(String content, String sign, String publicKey, String charset) {
        try {
            PublicKey pubKey = SignChecker.getPublicKeyFromX509("RSA", new ByteArrayInputStream(publicKey.getBytes()));
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initVerify(pubKey);
            if (StringUtils.isEmpty((CharSequence)charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            return signature.verify(Base64.decodeBase64((byte[])sign.getBytes()));
        }
        catch (Exception ex) {
            LogUtil.error((Logger)log, (String)("RSAcontent = " + content + ",sign=" + sign + ",charset = " + charset), (Throwable)ex);
            throw ApiInvokeException.API_INVALID_SIGIN;
        }
    }

    private static PublicKey getPublicKeyFromX509(String algorithm, InputStream ins) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        StringWriter writer = new StringWriter();
        SignChecker.io(new InputStreamReader(ins), writer);
        byte[] encodedKey = writer.toString().getBytes();
        encodedKey = Base64.decodeBase64((byte[])encodedKey);
        return keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
    }

    private static void io(Reader in, Writer out) throws IOException {
        SignChecker.io(in, out, -1);
    }

    private static String readText(Reader reader, int bufferSize) throws IOException {
        StringWriter writer = new StringWriter();
        SignChecker.io(reader, writer, bufferSize);
        return writer.toString();
    }

    private static String readText(InputStream in) throws IOException {
        return SignChecker.readText(in, null, -1);
    }

    private static String readText(InputStream in, String encoding, int bufferSize) throws IOException {
        InputStreamReader reader = encoding == null ? new InputStreamReader(in) : new InputStreamReader(in, encoding);
        return SignChecker.readText(reader, bufferSize);
    }

    private static void io(Reader in, Writer out, int bufferSize) throws IOException {
        int amount;
        if (bufferSize == -1) {
            bufferSize = 4096;
        }
        char[] buffer = new char[bufferSize];
        while ((amount = in.read(buffer)) >= 0) {
            out.write(buffer, 0, amount);
        }
    }
}

