/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.web.bean;

import com.fshows.fsframework.core.annotation.LifecircleApi;
import com.fshows.fsframework.web.constants.ApiConstants;
import com.fshows.fsframework.web.domain.ApiContainer;
import com.fshows.fsframework.web.domain.ApiDescriptor;
import com.fshows.fsframework.web.exception.ApiInvokeException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
public class ApiScanProcessor
implements BeanPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiScanProcessor.class);
    @Autowired
    private ApiContainer apiContainer;

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        Method[] methods;
        for (Method method : methods = ReflectionUtils.getAllDeclaredMethods(bean.getClass())) {
            LifecircleApi lifecircleApi = (LifecircleApi)AnnotationUtils.findAnnotation((Method)method, LifecircleApi.class);
            if (null == lifecircleApi) continue;
            int parameterCount = method.getParameterCount();
            if (ApiConstants.DEFAULT_API_PARAM_LENGTH != parameterCount) {
                String errorMsg = MessageFormat.format("\u3010API\u52a0\u8f7d\u5f02\u5e38\u3011\u65b9\u6cd5 method = {0}, \u6ce8\u89e3 @LifecircleApi \u4e0d\u5408\u6cd5, \u53c2\u6570\u4e2a\u6570\u4e0d\u7b49\u4e8e1", method.toGenericString());
                LOGGER.error(errorMsg);
                throw ApiInvokeException.API_PARAM_VALIDATE_ERROR.newInstance(errorMsg, new Object[0]);
            }
            String name = lifecircleApi.name();
            ApiDescriptor apiDescriptor = null;
            try {
                apiDescriptor = new ApiDescriptor(method.toGenericString(), name, beanName);
            }
            catch (Exception ex) {
                String msg = MessageFormat.format("\u3010API\u52a0\u8f7d\u5f02\u5e38\u3011,msg={0}", ex.getMessage());
                LOGGER.error(msg);
                throw ApiInvokeException.API_PARAM_VALIDATE_ERROR.newInstance(msg, new Object[0]);
            }
            this.apiContainer.put(name, apiDescriptor);
            LOGGER.info("\u5df2\u52a0\u8f7dAPI,name={},api={}", (Object)name, (Object)apiDescriptor);
        }
        return bean;
    }
}

