/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.web.service;

import com.fshows.fsframework.core.BaseParam;
import com.fshows.fsframework.web.bean.ApplicationContextHelper;
import com.fshows.fsframework.web.domain.ApiContainer;
import com.fshows.fsframework.web.domain.ApiDescriptor;
import com.fshows.fsframework.web.exception.ApiInvokeException;
import com.fshows.fsframework.web.service.IApiClient;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractApiInvokeService {
    @Autowired
    protected IApiClient apiClient;
    @Autowired
    protected ApiContainer apiContainer;

    public <P extends BaseParam, R> R invoke(String appId, String sign, String apiMethodName, Map<String, Object> params, String content) throws Throwable {
        ApiDescriptor apiDescriptor = (ApiDescriptor)this.apiContainer.get(apiMethodName);
        if (null == apiDescriptor) {
            throw ApiInvokeException.API_NOT_EXIST;
        }
        String beanName = apiDescriptor.getBeanName();
        Object bean = ApplicationContextHelper.getBean(beanName);
        if (null == bean) {
            throw ApiInvokeException.API_NOT_EXIST;
        }
        Boolean hasPermission = this.checkPermission(appId, apiMethodName);
        if (!hasPermission.booleanValue()) {
            throw ApiInvokeException.DO_NOT_HAS_PERMISSION;
        }
        Boolean checkSign = this.checkSign(params, appId);
        if (!checkSign.booleanValue()) {
            throw ApiInvokeException.API_INVALID_SIGIN;
        }
        return (R)this.apiClient.invoke(apiMethodName, content, (method, param) -> apiDescriptor.getMethod().invoke(bean, param));
    }

    public <P extends BaseParam, R> R invoke2(String appId, String sign, String apiMethodName, String traceId, Map<String, Object> params, String content) throws Throwable {
        ApiDescriptor apiDescriptor = (ApiDescriptor)this.apiContainer.get(apiMethodName);
        if (null == apiDescriptor) {
            throw ApiInvokeException.API_NOT_EXIST;
        }
        String beanName = apiDescriptor.getBeanName();
        Object bean = ApplicationContextHelper.getBean(beanName);
        if (null == bean) {
            throw ApiInvokeException.API_NOT_EXIST;
        }
        Boolean hasPermission = this.checkPermission(appId, apiMethodName);
        if (!hasPermission.booleanValue()) {
            throw ApiInvokeException.DO_NOT_HAS_PERMISSION;
        }
        Boolean checkSign = this.checkSign(params, appId);
        if (!checkSign.booleanValue()) {
            throw ApiInvokeException.API_INVALID_SIGIN;
        }
        return (R)this.apiClient.invoke2(apiMethodName, content, traceId, (method, param) -> apiDescriptor.getMethod().invoke(bean, param));
    }

    protected abstract boolean checkPermission(String var1, String var2);

    protected abstract boolean checkSign(Map<String, Object> var1, String var2);
}

