/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.web.service;

import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.fshows.fsframework.common.exception.BaseException;
import com.fshows.fsframework.core.BaseParam;
import com.fshows.fsframework.core.ValidateResult;
import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.core.utils.SystemClock;
import com.fshows.fsframework.core.utils.TraceIdGenerator;
import com.fshows.fsframework.core.utils.ValidateUtil;
import com.fshows.fsframework.web.constants.ApiConstants;
import com.fshows.fsframework.web.domain.ApiContainer;
import com.fshows.fsframework.web.domain.ApiDescriptor;
import com.fshows.fsframework.web.exception.ApiInvokeException;
import com.fshows.fsframework.web.service.ApiInvoker;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApiClient {
    private static final Logger log = LoggerFactory.getLogger(ApiClient.class);
    private static final ParserConfig FAST_JSON_PARSER_CONFIG = new ParserConfig();
    private static final String ERROR_INFO = "Http \u63a5\u53e3\u5f02\u5e38\u7ed3\u675f methodName = {},  exception = {}, time = {}ms";
    @Autowired
    private ApiContainer apiContainer;

    public <P extends BaseParam, R> R invoke(String method, String paramJsonStr, ApiInvoker<P, R> invoker) throws Throwable {
        long start = SystemClock.millisClock().now();
        String traceId = TraceIdGenerator.generate();
        MDC.put((String)"TRACE_ID", (String)traceId);
        RpcContext.getContext().setAttachment("TRACE_ID", traceId);
        LogUtil.info((Logger)log, (String)"Http \u63a5\u53e3\u5f00\u59cb methodName = {}, agruments = {}", (Object[])new Object[]{method, paramJsonStr});
        ApiDescriptor apiDescriptor = (ApiDescriptor)this.apiContainer.get(method);
        try {
            String[] paramFullNameList = apiDescriptor.getParamFullNameList();
            if (paramFullNameList == null || paramFullNameList.length < ApiConstants.DEFAULT_API_PARAM_LENGTH) {
                throw ApiInvokeException.API_PARAM_LENGTH_ERROR;
            }
            BaseParam result = (BaseParam)JSON.parseObject((String)paramJsonStr, Class.forName(paramFullNameList[0]), (ParserConfig)FAST_JSON_PARSER_CONFIG, (Feature[])new Feature[0]);
            ValidateResult validateResult = ValidateUtil.validate((Object)result);
            if (!validateResult.isResult()) {
                throw ApiInvokeException.API_PARAM_VALIDATE_ERROR.newInstance("\u53c2\u6570{0}{1}", validateResult.getParamName(), validateResult.getMsg());
            }
            R invoke = invoker.invoke(apiDescriptor, result);
            LogUtil.info((Logger)log, (String)"Http \u63a5\u53e3\u7ed3\u675f methodName = {}, result = {}, time = {}ms", (Object[])new Object[]{method, invoke, SystemClock.millisClock().now() - start});
            return invoke;
        }
        catch (ApiInvokeException e) {
            this.printInfoLog(method, start, (Exception)((Object)e));
            throw e;
        }
        catch (BaseException e) {
            this.printInfoLog(method, start, (Exception)((Object)e));
            throw e;
        }
        catch (InvocationTargetException e) {
            this.printInfoLog(method, start, e);
            throw e.getTargetException();
        }
        catch (Exception e) {
            this.printInfoLog(method, start, e);
            String msg = MessageFormat.format("API\u8c03\u7528\u5f02\u5e38,msg={0}", e.getMessage());
            LogUtil.error((Logger)log, (String)msg, (Throwable)e);
            throw ApiInvokeException.API_INVOKE_ERROR;
        }
    }

    private void printInfoLog(String method, long start, Exception e) {
        LogUtil.info((Logger)log, (String)ERROR_INFO, (Object[])new Object[]{method, e, SystemClock.millisClock().now() - start});
    }

    static {
        ApiClient.FAST_JSON_PARSER_CONFIG.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
    }
}

