/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.fsframework.web.service;

import com.alibaba.csp.sentinel.datasource.ReadableDataSource;
import com.alibaba.csp.sentinel.datasource.apollo.ApolloDataSource;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleManager;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import lombok.Data;

import java.util.List;

/**
 * 阿波罗配置监听器（单机版，非集群版）
 *
 * @author liluqing
 * @version SentinelConfig.java, v 0.1 2022-09-20 14:27
 */
@Data
public class SentinelApolloListener {

    /**
     * 阿波罗配置中心地址
     */
    private String apolloConfigServiceUrl;

    /**
     * 阿波罗配置中心的应用名称
     */
    private String appid;

    /**
     * 阿波罗配置中心 NameSpace 默认为“application”
     */
    private String NAMESPACE_NAME = "application";

    /**
     * 默认限流规则,默认为空
     */
    private String DEFAULT_FLOW_RULES = "[]";

    /**
     * 阿波罗配置中心存储限流规则的key
     */
    private String APOLLO_FLOW_RULE_KEY = "flow.rules";

    /**
     * 阿波罗配置中心存储的热点参数限流规则的key
     */
    private String APOLLO_FLOW_PARAM_RULE_KEY = "flow.param.rules";

    public SentinelApolloListener(String apolloConfigServiceUrl, String appid) {
        this.appid = appid;
        this.apolloConfigServiceUrl = apolloConfigServiceUrl;
    }

    /**
     * 初始化监听器
     *
     * @throws Exception
     */
    public void init() {
        System.setProperty("app.id", apolloConfigServiceUrl);
        System.setProperty("apollo.meta", appid);

        // 注册普通规则监听器
        ReadableDataSource<String, List<FlowRule>> flowRuleDataSource = new ApolloDataSource<>(NAMESPACE_NAME,
                APOLLO_FLOW_RULE_KEY, DEFAULT_FLOW_RULES, source -> JSON.parseObject(source, new TypeReference<List<FlowRule>>() {}));
        FlowRuleManager.register2Property(flowRuleDataSource.getProperty());

        // 注册热点参数规则监听器
        ReadableDataSource<String, List<ParamFlowRule>> flowParamRuleDataSource = new ApolloDataSource<>(NAMESPACE_NAME,
                APOLLO_FLOW_PARAM_RULE_KEY, DEFAULT_FLOW_RULES, source -> JSON.parseObject(source, new TypeReference<List<ParamFlowRule>>() {}));
        ParamFlowRuleManager.register2Property(flowParamRuleDataSource.getProperty());
    }
}