/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.web.service;

import com.alibaba.csp.sentinel.datasource.apollo.ApolloDataSource;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleManager;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.List;

public class SentinelApolloListener {
    private String apolloConfigServiceUrl;
    private String appid;
    private static final String NAMESPACE_NAME = "application";
    private static final String DEFAULT_FLOW_RULES = "[]";
    private static final String APOLLO_FLOW_RULE_KEY = "flow.rules";
    private static final String APOLLO_FLOW_PARAM_RULE_KEY = "flow.param.rules";

    public SentinelApolloListener(String apolloConfigServiceUrl, String appid) {
        this.appid = appid;
        this.apolloConfigServiceUrl = apolloConfigServiceUrl;
    }

    public void init() {
        System.setProperty("app.id", this.apolloConfigServiceUrl);
        System.setProperty("apollo.meta", this.appid);
        ApolloDataSource flowRuleDataSource = new ApolloDataSource(NAMESPACE_NAME, APOLLO_FLOW_RULE_KEY, DEFAULT_FLOW_RULES, source -> (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<FlowRule>>(){}, (Feature[])new Feature[0]));
        FlowRuleManager.register2Property((SentinelProperty)flowRuleDataSource.getProperty());
        ApolloDataSource flowParamRuleDataSource = new ApolloDataSource(NAMESPACE_NAME, APOLLO_FLOW_PARAM_RULE_KEY, DEFAULT_FLOW_RULES, source -> (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<ParamFlowRule>>(){}, (Feature[])new Feature[0]));
        ParamFlowRuleManager.register2Property((SentinelProperty)flowParamRuleDataSource.getProperty());
    }

    public String getApolloConfigServiceUrl() {
        return this.apolloConfigServiceUrl;
    }

    public String getAppid() {
        return this.appid;
    }

    public void setApolloConfigServiceUrl(String apolloConfigServiceUrl) {
        this.apolloConfigServiceUrl = apolloConfigServiceUrl;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SentinelApolloListener)) {
            return false;
        }
        SentinelApolloListener other = (SentinelApolloListener)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$apolloConfigServiceUrl = this.getApolloConfigServiceUrl();
        String other$apolloConfigServiceUrl = other.getApolloConfigServiceUrl();
        if (this$apolloConfigServiceUrl == null ? other$apolloConfigServiceUrl != null : !this$apolloConfigServiceUrl.equals(other$apolloConfigServiceUrl)) {
            return false;
        }
        String this$appid = this.getAppid();
        String other$appid = other.getAppid();
        return !(this$appid == null ? other$appid != null : !this$appid.equals(other$appid));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SentinelApolloListener;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apolloConfigServiceUrl = this.getApolloConfigServiceUrl();
        result = result * 59 + ($apolloConfigServiceUrl == null ? 43 : $apolloConfigServiceUrl.hashCode());
        String $appid = this.getAppid();
        result = result * 59 + ($appid == null ? 43 : $appid.hashCode());
        return result;
    }

    public String toString() {
        return "SentinelApolloListener(apolloConfigServiceUrl=" + this.getApolloConfigServiceUrl() + ", appid=" + this.getAppid() + ")";
    }
}

