/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.ext.core.extension.factory;

import com.fshows.fsframework.ext.core.BusinessScenario;
import com.fshows.fsframework.ext.core.annotation.IExtension;
import com.fshows.fsframework.ext.core.extension.ExtensionCoordinate;
import com.fshows.fsframework.ext.core.extension.ExtensionRepository;
import com.fshows.fsframework.ext.core.extension.IExtensionPoint;
import com.fshows.fsframework.ext.core.extension.factory.ExtensionFactory;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExtensionRegisterFactory
implements ExtensionFactory {
    private static final Logger log = LoggerFactory.getLogger(ExtensionRegisterFactory.class);
    @Resource
    private ExtensionRepository extensionRepository;

    @Override
    public void doRegister(IExtensionPoint extensionObject) {
        Class<?> extensionClz = extensionObject.getClass();
        IExtension extensionAnn = extensionClz.getAnnotation(IExtension.class);
        BusinessScenario businessScenario = BusinessScenario.valueOf(extensionAnn.businessId(), extensionAnn.useCase(), extensionAnn.scenario());
        ExtensionCoordinate extensionCoordinate = ExtensionCoordinate.valueOf(businessScenario, extensionObject);
        this.extensionRepository.register(extensionCoordinate);
    }

    @Override
    public <T> T get(BusinessScenario businessScenario, Class<T> clazz) {
        ExtensionCoordinate coordinate = this.extensionRepository.get(businessScenario);
        return (T)coordinate.getExtensionPoint();
    }
}

