/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.ext.core.extension;

import cn.hutool.core.util.ObjectUtil;
import com.fshows.fsframework.ext.core.BusinessScenario;
import com.fshows.fsframework.ext.core.extension.ExtensionCoordinate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExtensionRepository {
    private static final Logger log = LoggerFactory.getLogger(ExtensionRepository.class);
    private Map<String, ExtensionCoordinate> extensionRepository = new ConcurrentHashMap<String, ExtensionCoordinate>();

    public void register(ExtensionCoordinate extensionCoordinate) {
        BusinessScenario businessScenario = extensionCoordinate.getBusinessScenario();
        ExtensionCoordinate oldCoordinate = this.extensionRepository.put(businessScenario.getUniqueIdentity(), extensionCoordinate);
        if (ObjectUtil.isNotNull((Object)oldCoordinate)) {
            throw new RuntimeException(String.format("Duplicate registration is not allowed for :%s", extensionCoordinate));
        }
    }

    public ExtensionCoordinate get(BusinessScenario businessScenario) {
        ExtensionCoordinate coordinate = this.extensionRepository.get(businessScenario.getUniqueIdentity());
        if (coordinate == null) {
            log.error("\u83b7\u53d6\u4e1a\u52a1\u573a\u666f\u6269\u5c55\u70b9\u5b9e\u73b0\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u5c1a\u672a\u5b9a\u4e49\u8be5\u4e1a\u52a1\u573a\u666f\u76f8\u5173\u6269\u5c55\u70b9\u3002{}", (Object)businessScenario);
            throw new RuntimeException("\u5c1a\u672a\u5b9a\u4e49\u8be5\u4e1a\u52a1\u573a\u666f\u76f8\u5173\u6269\u5c55\u70b9 [" + businessScenario + "]");
        }
        return coordinate;
    }

    public Map<String, ExtensionCoordinate> getAll() {
        return this.extensionRepository;
    }
}

