/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.ext.core;

import java.io.Serializable;

public class BusinessScenario
implements Serializable {
    private static final long serialVersionUID = -5440151557874573533L;
    public static final String DEFAULT_BUSINESS_ID = "defaultBusinessId";
    public static final String DEFAULT_USE_CASE = "defaultUseCase";
    public static final String DEFAULT_SCENARIO = "defaultScenario";
    private static final String DOT_SEPARATOR = ".";
    private String businessId;
    private String useCase;
    private String scenario;

    public BusinessScenario() {
        this.businessId = DEFAULT_BUSINESS_ID;
        this.useCase = DEFAULT_USE_CASE;
        this.scenario = DEFAULT_SCENARIO;
    }

    public BusinessScenario(String businessId, String useCase, String scenario) {
        this.businessId = businessId;
        this.useCase = useCase;
        this.scenario = scenario;
    }

    public static BusinessScenario valueOf(String useCase, String scenario) {
        return new BusinessScenario(useCase, scenario);
    }

    public BusinessScenario(String useCase, String scenario) {
        this(DEFAULT_BUSINESS_ID, useCase, scenario);
    }

    public BusinessScenario(String scenario) {
        this(DEFAULT_BUSINESS_ID, DEFAULT_USE_CASE, scenario);
    }

    public static BusinessScenario valueOf(String businessId, String useCase, String scenario) {
        return new BusinessScenario(businessId, useCase, scenario);
    }

    public String getUniqueIdentity() {
        return this.businessId + DOT_SEPARATOR + this.useCase + DOT_SEPARATOR + this.scenario;
    }

    public String toString() {
        return "BusinessScenario{businessId='" + this.businessId + '\'' + ", useCase='" + this.useCase + '\'' + ", scenario='" + this.scenario + '\'' + '}';
    }

    public String getBusinessId() {
        return this.businessId;
    }

    public String getUseCase() {
        return this.useCase;
    }

    public String getScenario() {
        return this.scenario;
    }

    public void setBusinessId(String businessId) {
        this.businessId = businessId;
    }

    public void setUseCase(String useCase) {
        this.useCase = useCase;
    }

    public void setScenario(String scenario) {
        this.scenario = scenario;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BusinessScenario)) {
            return false;
        }
        BusinessScenario other = (BusinessScenario)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$businessId = this.getBusinessId();
        String other$businessId = other.getBusinessId();
        if (this$businessId == null ? other$businessId != null : !this$businessId.equals(other$businessId)) {
            return false;
        }
        String this$useCase = this.getUseCase();
        String other$useCase = other.getUseCase();
        if (this$useCase == null ? other$useCase != null : !this$useCase.equals(other$useCase)) {
            return false;
        }
        String this$scenario = this.getScenario();
        String other$scenario = other.getScenario();
        return !(this$scenario == null ? other$scenario != null : !this$scenario.equals(other$scenario));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BusinessScenario;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $businessId = this.getBusinessId();
        result = result * 59 + ($businessId == null ? 43 : $businessId.hashCode());
        String $useCase = this.getUseCase();
        result = result * 59 + ($useCase == null ? 43 : $useCase.hashCode());
        String $scenario = this.getScenario();
        result = result * 59 + ($scenario == null ? 43 : $scenario.hashCode());
        return result;
    }
}

