/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fsframework.ext.core.extension;

import com.fshows.fsframework.ext.core.BusinessScenario;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * 扩展点坐标
 * 用于定位唯一扩展点
 *
 * @author liangyuanping
 * @version ExtensionCoordinate.java, v 0.1 2022-07-16 6:08 下午 liangyuanping
 */
@EqualsAndHashCode(of = {"uniqueIdentify", "extensionPointName"})
@Data
public class ExtensionCoordinate implements Serializable {

    /**
     * 业务场景唯一标识(id)
     */
    private String uniqueIdentify;
    /**
     * 扩展点名
     */
    private String extensionPointName;
    /**
     * 扩展点类
     */
    private Class extensionPointClass;
    /**
     * 业务场景
     */
    private BusinessScenario businessScenario;
    /**
     * 扩展点实现类
     */
    private IExtensionPoint extensionPoint;

    public ExtensionCoordinate() {
    }

    public ExtensionCoordinate(BusinessScenario businessScenario, IExtensionPoint extensionPoint) {
        this.businessScenario = businessScenario;
        this.extensionPoint = extensionPoint;
        this.uniqueIdentify = this.businessScenario.getUniqueIdentity();
        this.extensionPointClass = this.extensionPoint.getClass();
    }

    /**
     * 构建扩展坐标
     *
     * @param businessScenario
     * @param point
     * @return
     */
    public static ExtensionCoordinate valueOf(BusinessScenario businessScenario, IExtensionPoint point) {
        return new ExtensionCoordinate(businessScenario, point);
    }
}