/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fsframework.ext.core.annotation;

import com.fshows.fsframework.ext.core.BusinessScenario;
import org.springframework.stereotype.Component;

import java.lang.annotation.*;

/**
 * 业务类使用该注解表示为"扩展点"
 *
 * @author liangyuanping
 * @version IExtension.java, v 0.1 2022-07-16 4:15 下午 liangyuanping
 */
@Component
@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface IExtension {

    String businessId() default BusinessScenario.DEFAULT_BUSINESS_ID;

    String useCase() default BusinessScenario.DEFAULT_USE_CASE;

    String scenario() default BusinessScenario.DEFAULT_SCENARIO;
}