/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fsframework.ext.core;

import cn.hutool.core.collection.CollectionUtil;
import com.fshows.fsframework.ext.core.annotation.IExtension;
import com.fshows.fsframework.ext.core.extension.ExtensionRepository;
import com.fshows.fsframework.ext.core.extension.IExtensionPoint;
import com.fshows.fsframework.ext.core.extension.factory.ExtensionFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.Map;

/**
 * @author liangyuanping
 * @version ExtensionBootstrap.java, v 0.1 2022-07-16 4:34 下午 liangyuanping
 */
@Slf4j
public class ExtensionBootstrap implements ApplicationContextAware {
    /**
     * applicationContext
     */
    private ApplicationContext applicationContext;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Resource
    private ExtensionFactory extensionFactory;
    @Resource
    private ExtensionRepository extensionRepository;

    /**
     * 初始化扩展点
     */
    @PostConstruct
    public void init() {
        Map<String, Object> extensionBeans = applicationContext.getBeansWithAnnotation(IExtension.class);
        if (CollectionUtil.isEmpty(extensionBeans)) {
            return;
        }
        //去注册
        extensionBeans.values().forEach(
                extension -> extensionFactory.doRegister((IExtensionPoint) extension)
        );
        log.debug("init >> 业务场景相关扩展点注册完成，注册数量: 【{}】", extensionRepository.getAll().size());
    }
}