/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fsframework.ext.config;

import com.fshows.fsframework.ext.core.ExtensionBootstrap;
import com.fshows.fsframework.ext.core.context.ExtensionContextHolder;
import com.fshows.fsframework.ext.core.context.ExtensionExecutor;
import com.fshows.fsframework.ext.core.extension.ExtensionRepository;
import com.fshows.fsframework.ext.core.extension.factory.ExtensionRegisterFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 使扩展点组件自动装配类
 *
 * @author liangyuanping
 * @version BusinessExtensionAutoConfiguration.java, v 0.1 2022-07-16 12:03 上午 liangyuanping
 */
@Configuration
public class BusinessExtensionAutoConfiguration {

    @Bean(initMethod = "init")
    @ConditionalOnMissingBean(ExtensionBootstrap.class)
    public ExtensionBootstrap extensionBootstrap() {
        return new ExtensionBootstrap();
    }

    @Bean
    @ConditionalOnMissingBean(ExtensionContextHolder.class)
    public ExtensionContextHolder extensionContextHolder() {
        return new ExtensionContextHolder();
    }

    @Bean
    @ConditionalOnMissingBean(ExtensionRegisterFactory.class)
    public ExtensionRegisterFactory extensionRegisterFactory() {
        return new ExtensionRegisterFactory();
    }

    @Bean
    @ConditionalOnMissingBean(ExtensionRepository.class)
    public ExtensionRepository extensionRepository() {
        return new ExtensionRepository();
    }

    @Bean
    @ConditionalOnMissingBean(ExtensionExecutor.class)
    public ExtensionExecutor extensionExecutor() {
        return new ExtensionExecutor();
    }
}