/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.dubbo.loadbalance;

import cn.hutool.core.util.StrUtil;
import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.cluster.loadbalance.RandomLoadBalance;
import com.beust.jcommander.internal.Lists;
import com.fshows.fsframework.core.utils.LogUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StableLoadBalance
extends RandomLoadBalance {
    private static final Logger log = LoggerFactory.getLogger(StableLoadBalance.class);
    public static final String SOURCE_KEY = "SOURCE_IP_KEY";
    public static final String STABLE_IP_KEY = "STABLE_IP_KEY";

    protected <T> Invoker<T> doSelect(List<Invoker<T>> invokers, URL url, Invocation invocation) {
        String stableIp;
        String sourceIp = RpcContext.getContext().getAttachment(SOURCE_KEY);
        LogUtil.info((Logger)log, (String)"doSelect \u5f00\u59cb >>  >> invokers = {}, url = {}, invocation = {}, sourceIp = {}", (Object[])new Object[]{invokers, url, invocation, sourceIp});
        if (StrUtil.isBlank((CharSequence)sourceIp)) {
            RpcContext.getContext().setAttachment(SOURCE_KEY, NetUtils.getLocalHost());
        }
        List filterIpInvokers = Lists.newArrayList();
        if (StrUtil.isNotBlank((CharSequence)sourceIp)) {
            filterIpInvokers = invokers.stream().filter(it -> !it.getUrl().getIp().equals(sourceIp)).collect(Collectors.toList());
        }
        if (filterIpInvokers.isEmpty() && StrUtil.isNotBlank((CharSequence)(stableIp = System.getProperty(STABLE_IP_KEY)))) {
            filterIpInvokers = invokers.stream().filter(it -> !it.getUrl().getIp().equals(stableIp)).collect(Collectors.toList());
        }
        if (!filterIpInvokers.isEmpty()) {
            invokers = filterIpInvokers;
        }
        LogUtil.info((Logger)log, (String)"doSelect \u7ed3\u675f >>  >> invokers = {}, url = {}, invocation = {}, filterIpInvokers = {}", (Object[])new Object[]{invokers, url, invocation, filterIpInvokers});
        return super.doSelect(invokers, url, invocation);
    }
}

