/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.dubbo.loadbalance;

import cn.hutool.core.util.StrUtil;
import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.cluster.loadbalance.RandomLoadBalance;
import com.beust.jcommander.internal.Lists;
import com.fshows.fsframework.core.utils.LogUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StableLoadBalance
extends RandomLoadBalance {
    private static final Logger log = LoggerFactory.getLogger(StableLoadBalance.class);
    public static final String NAME = "stable";
    public static final String ROUTE_TAG_CONTEXT_KEY = "ROUTE_TAG_CONTEXT_KEY";
    public static final String STABLE_ROUTE_TAG_KEY = "stable.route.tag";
    public static final String DEFAULT_ROUTE_TAG_KEY = "dubbo.provider.owner";
    private static final String DUBBO_ROUTE_TAG_KEY = "default.owner";

    public <T> Invoker<T> select(List<Invoker<T>> invokers, URL url, Invocation invocation) {
        return this.doSelect(invokers, url, invocation);
    }

    protected <T> Invoker<T> doSelect(List<Invoker<T>> invokers, URL url, Invocation invocation) {
        LogUtil.info((Logger)log, (String)"doSelect >> \u8def\u7531\u8fc7\u6ee4\u5f00\u59cb >> invokers = {}, url = {}, invocation = {}", (Object[])new Object[]{invokers, url, invocation});
        String sourceOwnerByContext = this.getRouteTagByContext();
        List<Invoker<T>> filterInvokersByGroup = this.filterInvokersByContextRouteTag(invokers, sourceOwnerByContext);
        if (StrUtil.isBlank((CharSequence)sourceOwnerByContext) || filterInvokersByGroup.isEmpty()) {
            filterInvokersByGroup = this.filterInvokersByStableRouteTag(invokers);
        }
        if (!filterInvokersByGroup.isEmpty()) {
            invokers = filterInvokersByGroup;
        }
        LogUtil.info((Logger)log, (String)"doSelect >> \u8def\u7531\u8fc7\u6ee4\u7ed3\u675f >> invokers = {}, url = {}, invocation = {}", (Object[])new Object[]{invokers, url, invocation});
        return super.doSelect(invokers, url, invocation);
    }

    private <T> List<Invoker<T>> filterInvokersByStableRouteTag(List<Invoker<T>> invokers) {
        List<Invoker<T>> result = invokers.stream().filter(it -> StrUtil.equalsIgnoreCase((CharSequence)it.getUrl().getParameter(DUBBO_ROUTE_TAG_KEY), (CharSequence)System.getProperty(STABLE_ROUTE_TAG_KEY))).collect(Collectors.toList());
        LogUtil.info((Logger)log, (String)"filterInvokersByStableRouteTag >> \u6839\u636e stable route tag \u8fc7\u6ee4 >> invokers = {}", (Object[])new Object[]{invokers});
        return result;
    }

    private <T> List<Invoker<T>> filterInvokersByContextRouteTag(List<Invoker<T>> invokers, String sourceOwnerByContext) {
        List<Invoker<T>> filterInvokersByGroup = Lists.newArrayList();
        if (StrUtil.isNotBlank((CharSequence)sourceOwnerByContext)) {
            filterInvokersByGroup = invokers.stream().filter(it -> StrUtil.equalsIgnoreCase((CharSequence)it.getUrl().getParameter(DUBBO_ROUTE_TAG_KEY), (CharSequence)sourceOwnerByContext)).collect(Collectors.toList());
        }
        LogUtil.info((Logger)log, (String)"doSelect >> \u6839\u636e\u4e0a\u4e0b\u6587\u8def\u7531 TAG \u8fc7\u6ee4\u8c03\u7528\u5217\u8868 >> sourceOwnerByContext = {}\uff0c filterInvokersByGroup = {}", (Object[])new Object[]{sourceOwnerByContext, filterInvokersByGroup});
        return filterInvokersByGroup;
    }

    private String getRouteTagByContext() {
        String sourceOwnerByContext = RpcContext.getContext().getAttachment(ROUTE_TAG_CONTEXT_KEY);
        LogUtil.info((Logger)log, (String)"doSelect >> \u83b7\u5f97\u4e0a\u4e0b\u6587\u8def\u7531 TAG >> sourceOwnerByContext = {}", (Object[])new Object[]{sourceOwnerByContext});
        if (StrUtil.isBlank((CharSequence)sourceOwnerByContext) && StrUtil.isNotBlank((CharSequence)(sourceOwnerByContext = System.getProperty(DEFAULT_ROUTE_TAG_KEY)))) {
            RpcContext.getContext().setAttachment(ROUTE_TAG_CONTEXT_KEY, sourceOwnerByContext);
            LogUtil.info((Logger)log, (String)"doSelect >> \u4e0a\u4e0b\u6587\u8def\u7531 TAG \u4e3a\u7a7a,\u4ece\u73af\u5883\u53d8\u91cf\u4e2d\u53d6\uff0c\u5e76\u8bbe\u7f6e\u5230\u4e0a\u4e0b\u6587\u4e2d >> sourceOwnerByContext = {}", (Object[])new Object[]{sourceOwnerByContext});
        }
        return sourceOwnerByContext;
    }
}

