/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.idgen.worker.repos;

import com.alibaba.dubbo.common.utils.NetUtils;
import com.fshows.fsframework.core.codec.JavaSerializer;
import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.extend.idgen.worker.WorkerNode;
import com.fshows.fsframework.extend.idgen.worker.repos.BaseWorkerNodeRepository;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.retry.RetryNTimes;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ZkWorkerNodeRepositoryImpl
extends BaseWorkerNodeRepository {
    private static final Logger log = LoggerFactory.getLogger(ZkWorkerNodeRepositoryImpl.class);
    private static final String ZK_PATH = "/idgen/workerid";
    private static final String ZK_LOCK_PATH = "/idgen/workerid/locker";
    private static final int ZK_RETRY_TIME = 5;
    private String zookeeperAddress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(WorkerNode workerNode) {
        block17: {
            try (CuratorFramework zkClient = null;){
                zkClient = CuratorFrameworkFactory.newClient((String)this.zookeeperAddress, (int)10000, (int)5000, (RetryPolicy)new RetryNTimes(5, 1000));
                if (zkClient.getState() != CuratorFrameworkState.STARTED) {
                    zkClient.start();
                }
                LogUtil.info((Logger)log, (String)"zookeeper server {} connected,client: {}", (Object[])new Object[]{this.zookeeperAddress, NetUtils.getLocalAddress()});
                String zkPath = MessageFormat.format("{0}/{1}", ZK_PATH, workerNode.getAppName());
                InterProcessMutex lock = new InterProcessMutex(zkClient, ZK_LOCK_PATH);
                if (!lock.acquire(3L, TimeUnit.SECONDS)) break block17;
                try {
                    Stat stat = (Stat)zkClient.checkExists().forPath(zkPath);
                    if (stat == null) {
                        ArrayList<WorkerNode> list = new ArrayList<WorkerNode>();
                        list.add(workerNode);
                        ((ACLBackgroundPathAndBytesable)zkClient.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(zkPath, JavaSerializer.serialize(list));
                    } else {
                        List sourceList;
                        byte[] bytesData = (byte[])zkClient.getData().forPath(zkPath);
                        if (bytesData != null && (sourceList = (List)JavaSerializer.deserialize((byte[])bytesData)) != null) {
                            boolean exist = sourceList.stream().anyMatch(item -> item.getHostName().equals(workerNode.getHostName()));
                            if (exist) {
                                return;
                            }
                            WorkerNode max = sourceList.stream().max((o1, o2) -> (int)(o1.getWorkerId() - o2.getWorkerId())).orElse(null);
                            if (max != null) {
                                long current = max.getWorkerId() + 1L;
                                workerNode.setWorkerId(current);
                                sourceList.add(workerNode);
                                zkClient.setData().forPath(zkPath, JavaSerializer.serialize((Object)sourceList));
                            }
                        }
                    }
                }
                finally {
                    lock.release();
                }
            }
        }
    }

    @Override
    public WorkerNode get(String hostName, String appName) {
        try (CuratorFramework zkClient = null;){
            List sourceList;
            byte[] bytesData;
            zkClient = CuratorFrameworkFactory.newClient((String)this.zookeeperAddress, (int)10000, (int)5000, (RetryPolicy)new RetryNTimes(5, 1000));
            if (zkClient.getState() != CuratorFrameworkState.STARTED) {
                zkClient.start();
            }
            LogUtil.info((Logger)log, (String)"zookeeper server {} connected,client: {}", (Object[])new Object[]{this.zookeeperAddress, NetUtils.getLocalAddress()});
            String zkPath = MessageFormat.format("{0}/{1}", ZK_PATH, appName);
            Stat stat = (Stat)zkClient.checkExists().forPath(zkPath);
            if (stat != null && (bytesData = (byte[])zkClient.getData().forPath(zkPath)) != null && (sourceList = (List)JavaSerializer.deserialize((byte[])bytesData)) != null) {
                WorkerNode node = sourceList.stream().filter(item -> item.getHostName().equals(hostName)).findFirst().orElse(null);
                if (node == null) {
                    WorkerNode workerNode = null;
                    return workerNode;
                }
                WorkerNode workerNode = node;
                return workerNode;
            }
        }
        return null;
    }

    public void setZookeeperAddress(String zookeeperAddress) {
        this.zookeeperAddress = zookeeperAddress;
    }
}

