/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.aliyun.mq.config;

import com.fshows.fsframework.extend.util.ConfigUtil;
import com.fshows.fsframework.extend.util.FsAESUtil;
import java.util.HashSet;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class FsMqConfig
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(FsMqConfig.class);
    private ApplicationContext applicationContext;
    @NotNull
    private String aesPasswordKey = "${fs.aliyun.key.aes.encry.password}";
    @NotNull
    private String accessKeyKey = "${fs.aliyun.mq.access.key}";
    @NotNull
    private String secretKeyKey = "${fs.aliyun.mq.secret.key}";
    private String producerCloseDelayTime = "${fs.aliyun.mq.producer.close.delay.time:30}";
    private String consumerRestartDelayTime = "${fs.aliyun.mq.consumer.restart.delay.time:30}";

    public String getAesPassword() {
        return ConfigUtil.getProperty(this.aesPasswordKey, this.applicationContext);
    }

    public String getDecryptedAccessKey() {
        String encryptedKey = ConfigUtil.getProperty(this.accessKeyKey, this.applicationContext);
        return this.decryptAkAndSk(encryptedKey, this.getAesPassword());
    }

    public String getDecryptedSecretKey() {
        String encryptedKey = ConfigUtil.getProperty(this.secretKeyKey, this.applicationContext);
        return this.decryptAkAndSk(encryptedKey, this.getAesPassword());
    }

    public Integer getProducerCloseDelayTime() {
        return ConfigUtil.getProperty(this.producerCloseDelayTime, Integer.class, this.applicationContext);
    }

    public Integer getConsumerRestartDelayTime() {
        return ConfigUtil.getProperty(this.consumerRestartDelayTime, Integer.class, this.applicationContext);
    }

    public Set<String> getWatchKeys() {
        HashSet<String> keys = new HashSet<String>();
        keys.add(ConfigUtil.getDynamicKey(this.aesPasswordKey));
        keys.add(ConfigUtil.getDynamicKey(this.accessKeyKey));
        keys.add(ConfigUtil.getDynamicKey(this.secretKeyKey));
        return keys;
    }

    public String getApolloKeyForAesPassword() {
        return ConfigUtil.getDynamicKey(this.aesPasswordKey);
    }

    public String getApolloKeyForAccessKey() {
        return ConfigUtil.getDynamicKey(this.accessKeyKey);
    }

    public String getApolloKeyForSecretKey() {
        return ConfigUtil.getDynamicKey(this.secretKeyKey);
    }

    public Boolean getMqClientDynamicUpdate() {
        return ConfigUtil.isDynamicProperty(this.accessKeyKey) && ConfigUtil.isDynamicProperty(this.secretKeyKey);
    }

    private String decryptAkAndSk(String ciphertext, String pwd) {
        if (StringUtils.length((CharSequence)ciphertext) < 32) {
            return ciphertext;
        }
        return FsAESUtil.decryptKey(ciphertext, pwd);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setAesPasswordKey(String aesPasswordKey) {
        this.aesPasswordKey = aesPasswordKey;
    }

    public void setAccessKeyKey(String accessKeyKey) {
        this.accessKeyKey = accessKeyKey;
    }

    public void setSecretKeyKey(String secretKeyKey) {
        this.secretKeyKey = secretKeyKey;
    }

    public void setProducerCloseDelayTime(String producerCloseDelayTime) {
        this.producerCloseDelayTime = producerCloseDelayTime;
    }

    public void setConsumerRestartDelayTime(String consumerRestartDelayTime) {
        this.consumerRestartDelayTime = consumerRestartDelayTime;
    }
}

