package com.fshows.fsframework.extend.aliyun.oss;

import com.aliyun.oss.OSSClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Auto configuration for FsOssClient.
 *
 * 条件：
 * 1) 仅当 classpath 存在 OSSClient 时生效
 * 2) 仅当必填配置存在时装配（aesPassword、encryAccessKey、encrySecretKey）
 * 3) 外部未声明 FsOssClient Bean 时才装配
 */
@Configuration
@ConditionalOnClass({OSSClient.class})
@ConditionalOnProperty(name = {
        "fs.aliyun.key.aes.encry.password",
        "fs.aliyun.oss.access.key",
        "fs.aliyun.oss.secret.key"
})
public class FsOssAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean(FsOssClient.class)
    public FsOssClient fsOssClient() {
        // FsOssClient 会在 @PostConstruct 内部完成 FsOssConfig 初始化和客户端创建
        return new FsOssClient();
    }
}
