/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.dubbo.filter;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.utils.ReflectUtils;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.RpcResult;
import com.alibaba.dubbo.rpc.filter.ExceptionFilter;
import com.alibaba.dubbo.rpc.service.GenericService;
import com.fshows.fsframework.common.exception.BaseException;
import java.lang.reflect.Method;

@Activate(group={"provider"})
public class GlobalExceptionFilter
implements Filter {
    private final Logger logger;

    public GlobalExceptionFilter() {
        this(LoggerFactory.getLogger(ExceptionFilter.class));
    }

    public GlobalExceptionFilter(Logger logger) {
        this.logger = logger;
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) {
        try {
            Result result = invoker.invoke(invocation);
            if (result.hasException() && GenericService.class != invoker.getInterface()) {
                try {
                    Throwable exception = result.getException();
                    if (!(exception instanceof RuntimeException) && exception instanceof Exception) {
                        return result;
                    }
                    try {
                        Class<?>[] exceptionClassses;
                        Method method = invoker.getInterface().getMethod(invocation.getMethodName(), invocation.getParameterTypes());
                        for (Class<?> exceptionClass : exceptionClassses = method.getExceptionTypes()) {
                            if (!exception.getClass().equals(exceptionClass)) continue;
                            return result;
                        }
                    }
                    catch (NoSuchMethodException e) {
                        return result;
                    }
                    this.logger.error("Got unchecked and undeclared exception which called by " + this.getErrorString(invoker, invocation, exception), exception);
                    String serviceFile = ReflectUtils.getCodeBase((Class)invoker.getInterface());
                    String exceptionFile = ReflectUtils.getCodeBase(exception.getClass());
                    String className = exception.getClass().getName();
                    if (serviceFile == null || exceptionFile == null || serviceFile.equals(exceptionFile) || exception instanceof BaseException) {
                        return result;
                    }
                    if (className.startsWith("java.") || className.startsWith("javax.")) {
                        return result;
                    }
                    if (exception instanceof RpcException) {
                        return result;
                    }
                    return new RpcResult((Throwable)new RuntimeException(StringUtils.toString((Throwable)exception)));
                }
                catch (Throwable e) {
                    this.logger.warn("Fail to ExceptionFilter when called by " + this.getErrorString(invoker, invocation, e), e);
                    return result;
                }
            }
            return result;
        }
        catch (RuntimeException e) {
            this.logger.error("Got unchecked and undeclared exception which called by " + this.getErrorString(invoker, invocation, e), (Throwable)e);
            throw e;
        }
    }

    private String getErrorString(Invoker<?> invoker, Invocation invocation, Throwable e) {
        return RpcContext.getContext().getRemoteHost() + ". service: " + invoker.getInterface().getName() + ", method: " + invocation.getMethodName() + ", exception: " + e.getClass().getName() + ": " + e.getMessage();
    }
}

