/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fsframework.extend.extension.context;

import com.fshows.fsframework.extend.extension.BusinessScenario;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 扩展组件执行器
 *
 * @author liangyuanping
 * @version ExtensionExecutor.java, v 0.1 2022-07-16 8:16 下午 liangyuanping
 */
@Component
@Slf4j
public class ExtensionExecutor extends AbstractComponentExecutor {

    @Resource
    private ExtensionContext extensionContext;

    @Override
    protected <C> C locateComponent(Class<C> targetClz, BusinessScenario bizScenario) {
        return extensionContext.getPoint(bizScenario, targetClz);
    }
}