/**
 * Zentech-Inc
 * Copyright (C) 2018 All Rights Reserved.
 */
package com.fshows.fsframework.extend.lock.exception;


/**
 * redis锁尝试加锁失败异常
 *
 * @author liluqing
 * @version $Id RedisTryLockException.java, v 0.1 2019-04-01 14:58
 */
public class RedisTryLockException extends LockException {


    private static final long serialVersionUID = -5740691674643051630L;

    /**
     * Default constructor
     */
    public RedisTryLockException() {
        super();
    }

    /**
     * Constructor with message & cause
     *
     * @param message
     * @param cause
     */
    public RedisTryLockException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructor with message
     *
     * @param message
     */
    public RedisTryLockException(String message) {
        super(message);
    }

    /**
     * Constructor with message format
     *
     * @param msgFormat
     * @param args
     */
    public RedisTryLockException(String msgFormat, Object... args) {
        super(String.format(msgFormat, args));
    }

    /**
     * Constructor with cause
     *
     * @param cause
     */
    public RedisTryLockException(Throwable cause) {
        super(cause);
    }
}
