/**
 * Zentech-Inc
 * Copyright (C) 2018 All Rights Reserved.
 */
package com.fshows.fsframework.extend.idgen.exception;

/**
 * IdGenerateException
 *
 * @author wujn
 * @version $Id IdGenerateException.java, v 0.1 2018-01-29 11:21
 */
public class IdGenerateException extends RuntimeException {

    /**
     * Serial Version UID
     */
    private static final long serialVersionUID = -27048199131316992L;

    /**
     * Default constructor
     */
    public IdGenerateException() {
        super();
    }

    /**
     * Constructor with message & cause
     *
     * @param message
     * @param cause
     */
    public IdGenerateException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructor with message
     *
     * @param message
     */
    public IdGenerateException(String message) {
        super(message);
    }

    /**
     * Constructor with message format
     *
     * @param msgFormat
     * @param args
     */
    public IdGenerateException(String msgFormat, Object... args) {
        super(String.format(msgFormat, args));
    }

    /**
     * Constructor with cause
     *
     * @param cause
     */
    public IdGenerateException(Throwable cause) {
        super(cause);
    }

}
