/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fsframework.extend.extension.factory;

import com.fshows.fsframework.extend.extension.BusinessScenario;
import com.fshows.fsframework.extend.extension.ExtensionCoordinate;
import com.fshows.fsframework.extend.extension.ExtensionRepository;
import com.fshows.fsframework.extend.extension.IExtensionPoint;
import com.fshows.fsframework.extend.extension.annotation.IExtension;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 扩展点注册
 *
 * @author liangyuanping
 * @version ExtensionRegisterFactory.java, v 0.1 2022-07-16 5:13 下午 liangyuanping
 */
@Component
@Slf4j
public class ExtensionRegisterFactory implements ExtensionFactory {

    @Resource
    private ExtensionRepository extensionRepository;

    /**
     * 注册扩展点
     *
     * @param extensionObject 扩展点
     */
    @Override
    public void doRegister(IExtensionPoint extensionObject) {
        Class<?> extensionClz = extensionObject.getClass();
        IExtension extensionAnn = extensionClz.getAnnotation(IExtension.class);
        BusinessScenario businessScenario = BusinessScenario.valueOf(extensionAnn.businessId(), extensionAnn.useCase(), extensionAnn.scenario());
//        this.checkExtensionPoint(extensionClz);
        ExtensionCoordinate extensionCoordinate = ExtensionCoordinate.valueOf(businessScenario, extensionObject);
        extensionRepository.register(extensionCoordinate);
    }

    /**
     * 获取扩展点
     *
     * @param businessScenario
     * @param clazz
     * @param <T>
     * @return
     */
    @Override
    public <T> T get(BusinessScenario businessScenario, Class<T> clazz) {
        ExtensionCoordinate coordinate = extensionRepository.get(businessScenario);
        return (T) coordinate.getExtensionPoint();
    }

    /**
     * 检查扩展点名
     *
     * @param targetBean
     * @return
     */
//    private void checkExtensionPoint(Class<?> targetBean) {
//        Class[] interfaces = targetBean.getInterfaces();
//        if (interfaces == null || interfaces.length == 0) {
//            throw new RuntimeException(String.format("No extension point interface for %s", targetBean));
//        }
//        // 扩展点接口名必须以ExtPt结尾
//        Optional<Class> extPointClass = Arrays.stream(interfaces)
//                .filter(ext -> ext.getSimpleName().endsWith(IExtensionPoint.EXT_POINT_NAMING))
//                .findFirst();
//        if (!extPointClass.isPresent()) {
//            throw new RuntimeException(
//                    String.format("The name of ExtensionPoint for %s must be end with %s", targetBean, IExtensionPoint.EXT_POINT_NAMING));
//        }
//    }
}