/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.fsframework.extend.aliyun.mq;

import com.aliyun.openservices.ons.api.ONSFactory;
import com.fshows.fsframework.extend.aliyun.mq.config.FsMqConfig;
import com.fshows.fsframework.extend.aliyun.mq.core.FsMqInstanceManager;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

/**
 * MQ组件自动配置类
 *
 * 条件：
 * 1) 仅当 classpath 存在 ONSFactory 时生效
 * 2) 仅当必填配置存在时装配（aesPassword、accessKey、secretKey）
 * 3) 外部未声明相应 Bean 时才装配
 *
 * @author liluqing
 * @version FsMqAutoConfiguration.java, v 0.1 2025-01-10 16:30
 */
@Configuration
@ConditionalOnClass({ONSFactory.class})
@ConditionalOnProperty(name = {
        "fs.aliyun.key.aes.encry.password",
        "fs.aliyun.mq.access.key",
        "fs.aliyun.mq.secret.key"
})
@ComponentScan("com.fshows.fsframework.extend.aliyun.mq.core")
public class FsMqAutoConfiguration {

    /**
     * 自动装配MQ配置类
     */
    @Bean
    @ConditionalOnMissingBean(FsMqConfig.class)
    public FsMqConfig fsMqConfig() {
        return new FsMqConfig();
    }

    /**
     * 自动装配MQ实例管理器
     */
    @Bean
    @ConditionalOnMissingBean(FsMqInstanceManager.class)
    public FsMqInstanceManager fsMqInstanceManager(FsMqConfig fsMqConfig) {
        FsMqInstanceManager instanceManager = new FsMqInstanceManager();
        instanceManager.setFsMqConfig(fsMqConfig);
        return instanceManager;
    }
}
