/**
 * Zentech-Inc
 * Copyright (C) 2018 All Rights Reserved.
 */
package com.fshows.fsframework.extend.lock.exception;


/**
 * @author wujn
 * @version $Id WorkerIdAssignException.java, v 0.1 2018-02-01 14:58
 */
public class RedisLockException extends LockException {


    private static final long serialVersionUID = -5740691674643051630L;

    /**
     * Default constructor
     */
    public RedisLockException() {
        super();
    }

    /**
     * Constructor with message & cause
     *
     * @param message
     * @param cause
     */
    public RedisLockException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructor with message
     *
     * @param message
     */
    public RedisLockException(String message) {
        super(message);
    }

    /**
     * Constructor with message format
     *
     * @param msgFormat
     * @param args
     */
    public RedisLockException(String msgFormat, Object... args) {
        super(String.format(msgFormat, args));
    }

    /**
     * Constructor with cause
     *
     * @param cause
     */
    public RedisLockException(Throwable cause) {
        super(cause);
    }
}
