/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.aliyun.oss;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.HexUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.digest.DigestUtil;
import cn.hutool.crypto.symmetric.AES;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.ObjectMetadata;
import com.ctrip.framework.apollo.enums.PropertyChangeType;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import com.fshows.fsframework.common.exception.CommonException;
import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.extend.util.FsAESUtil;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FsOssClient {
    private static final Logger log = LoggerFactory.getLogger(FsOssClient.class);
    @Value(value="${fs.aliyun.oss.out.url:https://oss-cn-hangzhou.aliyuncs.com}")
    private String ossEndPointOut;
    @Value(value="${fs.aliyun.oss.inner.url:https://oss-cn-hangzhou-internal.aliyuncs.com}")
    private String ossEndPointInner;
    @Value(value="${fs.aliyun.oss.url.expire.time:3600}")
    private Long urlExpireTime;
    @Value(value="${fs.aliyun.key.aes.encry.password}")
    private String aesPassword;
    private static final String OSS_ACCESS_KEY_PREFIX = "fs.aliyun.oss.access.key";
    private static final String OSS_SECRET_KEY_PREFIX = "fs.aliyun.oss.secret.key";
    private static final String BACKSLASH = "/";
    @Value(value="${fs.aliyun.oss.access.key}")
    private String encryAccessKey;
    @Value(value="${fs.aliyun.oss.secret.key}")
    private String encrySecretKey;
    private volatile OSSClient outOssClient;
    private volatile OSSClient innerOssClient;
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);

    @PostConstruct
    public void init() {
        String decryptAccess = FsAESUtil.decryptKey(this.encryAccessKey, this.aesPassword);
        String decryptSecret = FsAESUtil.decryptKey(this.encrySecretKey, this.aesPassword);
        if (this.outOssClient == null) {
            this.outOssClient = new OSSClient(this.ossEndPointOut, decryptAccess, decryptSecret);
        }
        if (this.innerOssClient == null) {
            this.innerOssClient = new OSSClient(this.ossEndPointInner, decryptAccess, decryptSecret);
        }
        LogUtil.info((Logger)log, (String)"FsOssClient\u521d\u59cb\u5316\u5b8c\u6210");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApolloConfigChangeListener
    public synchronized void refreshOssClient(ConfigChangeEvent changeEvent) {
        LogUtil.info((Logger)log, (String)"refreshOssClient >> \u63a5\u6536\u5230AKSK\u53d8\u6362\u901a\u77e5");
        ConfigChange accessConfigChange = changeEvent.getChange(OSS_ACCESS_KEY_PREFIX);
        ConfigChange secretConfigChange = changeEvent.getChange(OSS_SECRET_KEY_PREFIX);
        LogUtil.info((Logger)log, (String)"refreshOssClient >> \u63a5\u6536\u5230AKSK\u53d8\u6362\u901a\u77e5 >> access={} , secret={}", (Object[])new Object[]{accessConfigChange, secretConfigChange});
        String refreshEncryAccessKey = this.encryAccessKey;
        if (accessConfigChange != null && !accessConfigChange.getChangeType().equals((Object)PropertyChangeType.DELETED) && !accessConfigChange.getOldValue().equals(accessConfigChange.getNewValue())) {
            refreshEncryAccessKey = accessConfigChange.getNewValue();
        }
        String refreshEncrySecretKey = this.encrySecretKey;
        if (secretConfigChange != null && !secretConfigChange.getChangeType().equals((Object)PropertyChangeType.DELETED) && !secretConfigChange.getOldValue().equals(secretConfigChange.getNewValue())) {
            refreshEncrySecretKey = secretConfigChange.getNewValue();
        }
        if (refreshEncryAccessKey.equals(this.encryAccessKey) && refreshEncrySecretKey.equals(this.encrySecretKey)) {
            LogUtil.info((Logger)log, (String)"refreshOssClient >> aksk\u6ca1\u6709\u53d1\u751f\u8fc7\u53d8\u66f4 >> access={} , secret={}", (Object[])new Object[]{accessConfigChange, secretConfigChange});
            return;
        }
        OSSClient tmpOutOssClient = this.outOssClient;
        OSSClient tmpInnerOssClient = this.innerOssClient;
        String accessKey = FsAESUtil.decryptKey(refreshEncryAccessKey, this.aesPassword);
        String secretKey = FsAESUtil.decryptKey(refreshEncrySecretKey, this.aesPassword);
        try {
            LogUtil.info((Logger)log, (String)"refreshOssClient >> \u521d\u59cb\u5316\u65b0\u5ba2\u6237\u7aef >> accessKey={} , secretKey={}", (Object[])new Object[]{accessKey, secretKey});
            this.outOssClient = new OSSClient(this.ossEndPointOut, accessKey, secretKey);
            this.innerOssClient = new OSSClient(this.ossEndPointInner, accessKey, secretKey);
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"refreshOssClient >> oss\u52a8\u6001\u66ff\u6362aksk\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.executorService.schedule(() -> {
                if (tmpOutOssClient != null && tmpOutOssClient != this.outOssClient) {
                    tmpOutOssClient.shutdown();
                }
                if (tmpInnerOssClient != null && tmpInnerOssClient != this.innerOssClient) {
                    tmpInnerOssClient.shutdown();
                }
                LogUtil.info((Logger)log, (String)"refreshOssClient >> \u65e7\u5ba2\u6237\u7aef\u5173\u95ed\u5b8c\u6210");
            }, 30L, TimeUnit.SECONDS);
        }
    }

    public void uploadFileWithOutFlag(String bucketName, String key, InputStream inputStream, boolean outOssFlag) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw CommonException.INVALID_PARAM_ERROR.newInstance("Oss key is null", new Object[0]);
        }
        if (key.startsWith(BACKSLASH)) {
            key = key.substring(1);
        }
        if (outOssFlag) {
            this.outOssClient.putObject(bucketName, key, inputStream);
        } else {
            this.innerOssClient.putObject(bucketName, key, inputStream);
        }
    }

    public void uploadFileWithOutFlag(String bucketName, String key, File file, boolean outOssFlag) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw CommonException.INVALID_PARAM_ERROR.newInstance("Oss key is null", new Object[0]);
        }
        if (key.startsWith(BACKSLASH)) {
            key = key.substring(1);
        }
        if (outOssFlag) {
            this.outOssClient.putObject(bucketName, key, file);
        } else {
            this.innerOssClient.putObject(bucketName, key, file);
        }
    }

    public void uploadFile(String bucketName, String key, String filePath) {
        File file = new File(filePath);
        this.uploadFileWithOutFlag(bucketName, key, file, false);
    }

    public void uploadFile(String bucketName, String key, File file) {
        this.uploadFileWithOutFlag(bucketName, key, file, false);
    }

    public void uploadFile(String bucketName, String key, InputStream inputStream) {
        this.uploadFileWithOutFlag(bucketName, key, inputStream, false);
    }

    public void uploadFile(String bucketName, String key, String filename, ObjectMetadata metadata) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw CommonException.INVALID_PARAM_ERROR.newInstance("Oss key is null", new Object[0]);
        }
        if (key.startsWith(BACKSLASH)) {
            key = key.substring(1);
        }
        File file = new File(filename);
        this.innerOssClient.putObject(bucketName, key, file, metadata);
    }

    public void downloadFileWithOutFlag(String bucketName, String key, String filePath, boolean outFlag) {
        if (key.startsWith(BACKSLASH)) {
            key = key.substring(1);
        }
        if (outFlag) {
            this.outOssClient.getObject(new GetObjectRequest(bucketName, key), new File(filePath));
        } else {
            this.innerOssClient.getObject(new GetObjectRequest(bucketName, key), new File(filePath));
        }
    }

    public void downloadFileWithOutFlag(String bucketName, String key, File file, boolean outFlag) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw CommonException.INVALID_PARAM_ERROR.newInstance("Oss key is null", new Object[0]);
        }
        if (key.startsWith(BACKSLASH)) {
            key = key.substring(1);
        }
        if (outFlag) {
            this.outOssClient.getObject(new GetObjectRequest(bucketName, key), file);
        } else {
            this.innerOssClient.getObject(new GetObjectRequest(bucketName, key), file);
        }
    }

    public void downloadFile(String bucketName, String key, String filePath) {
        this.downloadFileWithOutFlag(bucketName, key, filePath, false);
    }

    public void downloadFile(String bucketName, String key, File file) {
        this.downloadFileWithOutFlag(bucketName, key, file, false);
    }

    public void downloadFileKeep(String bucketName, String key, File file) {
        if (key.startsWith(BACKSLASH)) {
            key = key.substring(1);
        }
        this.downloadFileWithOutFlag(bucketName, key, file, false);
    }

    public String generateFileUrlWithExpireAndOutFlag(String bucketName, String key, boolean outFlag, Long expireTime) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw CommonException.INVALID_PARAM_ERROR.newInstance("Oss key is null", new Object[0]);
        }
        if (key.startsWith(BACKSLASH)) {
            key = key.substring(1);
        }
        Date time = new Date(System.currentTimeMillis() + (Objects.isNull(expireTime) ? this.urlExpireTime : expireTime));
        if (outFlag) {
            return this.outOssClient.generatePresignedUrl(bucketName, key, time).toString();
        }
        return this.innerOssClient.generatePresignedUrl(bucketName, key, time).toString();
    }

    public String generateFileUrlWithOutFlag(String bucketName, String key, boolean outFlag) {
        return this.generateFileUrlWithExpireAndOutFlag(bucketName, key, outFlag, null);
    }

    public String generateFileUrl(String bucketName, String key) {
        return this.generateFileUrlWithExpireAndOutFlag(bucketName, key, true, null);
    }

    public String generateFileUrl(String bucketName, String key, Long expireTime) {
        return this.generateFileUrlWithExpireAndOutFlag(bucketName, key, true, expireTime);
    }

    public void deleteFile(String bucketName, String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw CommonException.INVALID_PARAM_ERROR.newInstance("Oss key is null", new Object[0]);
        }
        if (key.startsWith(BACKSLASH)) {
            key = key.substring(1, key.length());
        }
        this.innerOssClient.deleteObject(bucketName, key);
    }

    public static void main(String[] args) {
        byte[] md5SecretKey = DigestUtil.md5((byte[])DigestUtil.md5((byte[])"406c42688e7f7db4a8f3912772725a5d".getBytes(StandardCharsets.UTF_8)));
        System.out.println("password md5: " + new String(HexUtil.encodeHex((byte[])md5SecretKey)));
        AES aes = SecureUtil.aes((byte[])md5SecretKey);
        String accessKey = "LTAI5tMacBHafqzmAfK4DdoK";
        String secretKey = "vNbUdImu3eSX8yKi5jl2nMG8oneFGW";
        String encryAccessKey = Base64.encode((byte[])aes.encrypt(accessKey));
        String encrySecretKey = Base64.encode((byte[])aes.encrypt(secretKey));
        System.out.println("oss accessKey encode: " + new String(HexUtil.encodeHex((byte[])Base64.decode((String)encryAccessKey))));
        System.out.println("oss accessKey encode: " + new String(HexUtil.encodeHex((byte[])Base64.decode((String)encrySecretKey))));
        String decryptAccessKey = new String(aes.decrypt(Base64.decode((String)encryAccessKey)));
        String decryptSecretKey = new String(aes.decrypt(Base64.decode((String)encrySecretKey)));
        System.out.println("oss accessKey decode: " + decryptAccessKey);
        System.out.println("oss secretKey decode: " + decryptSecretKey);
    }
}

