/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.dubbo.model;

import com.alibaba.fastjson.JSON;
import com.fshows.fsframework.core.utils.FsDateUtil;
import com.google.common.collect.Lists;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class DubboThreadPoolMonitorConfigConvertModel {
    private List<ThreadPoolMonitorPointConfigConvertModel> threadPoolMonitorPointConfigList;
    private Integer applicationThreadCount;
    private static ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public static void main(String[] args) {
        DubboThreadPoolMonitorConfigConvertModel threadPoolMonitorConfigConvertModel = new DubboThreadPoolMonitorConfigConvertModel();
        threadPoolMonitorConfigConvertModel.setApplicationThreadCount(500);
        ArrayList threadPoolMonitorPointConfigList = Lists.newArrayList();
        ThreadPoolMonitorPointConfigConvertModel threadPoolMonitorPointConfigConvertModel = new ThreadPoolMonitorPointConfigConvertModel();
        threadPoolMonitorPointConfigConvertModel.setMonitorFrequency(5);
        threadPoolMonitorPointConfigConvertModel.setMonitorPeriodStartTime(LocalTime.parse("09:50:00", DateTimeFormatter.ofPattern("HH:mm:ss")));
        threadPoolMonitorPointConfigConvertModel.setMonitorPeriodEndTime(LocalTime.parse("09:51:59", DateTimeFormatter.ofPattern("HH:mm:ss")));
        threadPoolMonitorPointConfigConvertModel.setUsageThreshold(0.8f);
        threadPoolMonitorPointConfigList.add(threadPoolMonitorPointConfigConvertModel);
        threadPoolMonitorPointConfigConvertModel = new ThreadPoolMonitorPointConfigConvertModel();
        threadPoolMonitorPointConfigConvertModel.setMonitorFrequency(30);
        threadPoolMonitorPointConfigConvertModel.setMonitorPeriodStartTime(LocalTime.parse("09:52:00", DateTimeFormatter.ofPattern("HH:mm:ss")));
        threadPoolMonitorPointConfigConvertModel.setMonitorPeriodEndTime(LocalTime.parse("09:52:59", DateTimeFormatter.ofPattern("HH:mm:ss")));
        threadPoolMonitorPointConfigConvertModel.setUsageThreshold(0.8f);
        threadPoolMonitorPointConfigList.add(threadPoolMonitorPointConfigConvertModel);
        threadPoolMonitorPointConfigConvertModel = new ThreadPoolMonitorPointConfigConvertModel();
        threadPoolMonitorPointConfigConvertModel.setMonitorFrequency(10);
        threadPoolMonitorPointConfigConvertModel.setMonitorPeriodStartTime(LocalTime.parse("09:53:00", DateTimeFormatter.ofPattern("HH:mm:ss")));
        threadPoolMonitorPointConfigConvertModel.setMonitorPeriodEndTime(LocalTime.parse("09:53:59", DateTimeFormatter.ofPattern("HH:mm:ss")));
        threadPoolMonitorPointConfigConvertModel.setUsageThreshold(0.8f);
        threadPoolMonitorPointConfigList.add(threadPoolMonitorPointConfigConvertModel);
        threadPoolMonitorConfigConvertModel.setThreadPoolMonitorPointConfigList(threadPoolMonitorPointConfigList);
        System.out.println(JSON.toJSONString((Object)threadPoolMonitorConfigConvertModel));
        for (ThreadPoolMonitorPointConfigConvertModel config : threadPoolMonitorConfigConvertModel.getThreadPoolMonitorPointConfigList()) {
            LocalTime start = config.getMonitorPeriodStartTime();
            LocalTime end = config.getMonitorPeriodEndTime();
            long monitorFrequency = config.getMonitorFrequency().intValue();
            DubboThreadPoolMonitorConfigConvertModel.scheduleTaskAtFixedRate(start, end, monitorFrequency, config.getUsageThreshold());
        }
    }

    private static void scheduleTaskAtFixedRate(LocalTime start, LocalTime end, long monitorFrequency, float usageThreshold) {
        long initialDelay = DubboThreadPoolMonitorConfigConvertModel.calculateInitialDelay(start);
        Runnable task = () -> {
            LocalTime now = LocalTime.now();
            if (now.isAfter(start) && now.isBefore(end)) {
                System.out.println("Performing monitoring with threshold: " + FsDateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
        };
        scheduler.scheduleAtFixedRate(task, initialDelay, monitorFrequency, TimeUnit.SECONDS);
    }

    private static long calculateInitialDelay(LocalTime start) {
        LocalTime now = LocalTime.now();
        if (now.isBefore(start)) {
            return now.until(start, ChronoUnit.SECONDS);
        }
        return 0L;
    }

    public List<ThreadPoolMonitorPointConfigConvertModel> getThreadPoolMonitorPointConfigList() {
        return this.threadPoolMonitorPointConfigList;
    }

    public Integer getApplicationThreadCount() {
        return this.applicationThreadCount;
    }

    public void setThreadPoolMonitorPointConfigList(List<ThreadPoolMonitorPointConfigConvertModel> threadPoolMonitorPointConfigList) {
        this.threadPoolMonitorPointConfigList = threadPoolMonitorPointConfigList;
    }

    public void setApplicationThreadCount(Integer applicationThreadCount) {
        this.applicationThreadCount = applicationThreadCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DubboThreadPoolMonitorConfigConvertModel)) {
            return false;
        }
        DubboThreadPoolMonitorConfigConvertModel other = (DubboThreadPoolMonitorConfigConvertModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ThreadPoolMonitorPointConfigConvertModel> this$threadPoolMonitorPointConfigList = this.getThreadPoolMonitorPointConfigList();
        List<ThreadPoolMonitorPointConfigConvertModel> other$threadPoolMonitorPointConfigList = other.getThreadPoolMonitorPointConfigList();
        if (this$threadPoolMonitorPointConfigList == null ? other$threadPoolMonitorPointConfigList != null : !((Object)this$threadPoolMonitorPointConfigList).equals(other$threadPoolMonitorPointConfigList)) {
            return false;
        }
        Integer this$applicationThreadCount = this.getApplicationThreadCount();
        Integer other$applicationThreadCount = other.getApplicationThreadCount();
        return !(this$applicationThreadCount == null ? other$applicationThreadCount != null : !((Object)this$applicationThreadCount).equals(other$applicationThreadCount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DubboThreadPoolMonitorConfigConvertModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ThreadPoolMonitorPointConfigConvertModel> $threadPoolMonitorPointConfigList = this.getThreadPoolMonitorPointConfigList();
        result = result * 59 + ($threadPoolMonitorPointConfigList == null ? 43 : ((Object)$threadPoolMonitorPointConfigList).hashCode());
        Integer $applicationThreadCount = this.getApplicationThreadCount();
        result = result * 59 + ($applicationThreadCount == null ? 43 : ((Object)$applicationThreadCount).hashCode());
        return result;
    }

    public String toString() {
        return "DubboThreadPoolMonitorConfigConvertModel(threadPoolMonitorPointConfigList=" + this.getThreadPoolMonitorPointConfigList() + ", applicationThreadCount=" + this.getApplicationThreadCount() + ")";
    }

    public static class ThreadPoolMonitorPointConfigConvertModel {
        private LocalTime monitorPeriodStartTime;
        private LocalTime monitorPeriodEndTime;
        private Integer monitorFrequency;
        private float usageThreshold;

        public LocalTime getMonitorPeriodStartTime() {
            return this.monitorPeriodStartTime;
        }

        public LocalTime getMonitorPeriodEndTime() {
            return this.monitorPeriodEndTime;
        }

        public Integer getMonitorFrequency() {
            return this.monitorFrequency;
        }

        public float getUsageThreshold() {
            return this.usageThreshold;
        }

        public void setMonitorPeriodStartTime(LocalTime monitorPeriodStartTime) {
            this.monitorPeriodStartTime = monitorPeriodStartTime;
        }

        public void setMonitorPeriodEndTime(LocalTime monitorPeriodEndTime) {
            this.monitorPeriodEndTime = monitorPeriodEndTime;
        }

        public void setMonitorFrequency(Integer monitorFrequency) {
            this.monitorFrequency = monitorFrequency;
        }

        public void setUsageThreshold(float usageThreshold) {
            this.usageThreshold = usageThreshold;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ThreadPoolMonitorPointConfigConvertModel)) {
                return false;
            }
            ThreadPoolMonitorPointConfigConvertModel other = (ThreadPoolMonitorPointConfigConvertModel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LocalTime this$monitorPeriodStartTime = this.getMonitorPeriodStartTime();
            LocalTime other$monitorPeriodStartTime = other.getMonitorPeriodStartTime();
            if (this$monitorPeriodStartTime == null ? other$monitorPeriodStartTime != null : !((Object)this$monitorPeriodStartTime).equals(other$monitorPeriodStartTime)) {
                return false;
            }
            LocalTime this$monitorPeriodEndTime = this.getMonitorPeriodEndTime();
            LocalTime other$monitorPeriodEndTime = other.getMonitorPeriodEndTime();
            if (this$monitorPeriodEndTime == null ? other$monitorPeriodEndTime != null : !((Object)this$monitorPeriodEndTime).equals(other$monitorPeriodEndTime)) {
                return false;
            }
            Integer this$monitorFrequency = this.getMonitorFrequency();
            Integer other$monitorFrequency = other.getMonitorFrequency();
            if (this$monitorFrequency == null ? other$monitorFrequency != null : !((Object)this$monitorFrequency).equals(other$monitorFrequency)) {
                return false;
            }
            return Float.compare(this.getUsageThreshold(), other.getUsageThreshold()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof ThreadPoolMonitorPointConfigConvertModel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LocalTime $monitorPeriodStartTime = this.getMonitorPeriodStartTime();
            result = result * 59 + ($monitorPeriodStartTime == null ? 43 : ((Object)$monitorPeriodStartTime).hashCode());
            LocalTime $monitorPeriodEndTime = this.getMonitorPeriodEndTime();
            result = result * 59 + ($monitorPeriodEndTime == null ? 43 : ((Object)$monitorPeriodEndTime).hashCode());
            Integer $monitorFrequency = this.getMonitorFrequency();
            result = result * 59 + ($monitorFrequency == null ? 43 : ((Object)$monitorFrequency).hashCode());
            result = result * 59 + Float.floatToIntBits(this.getUsageThreshold());
            return result;
        }

        public String toString() {
            return "DubboThreadPoolMonitorConfigConvertModel.ThreadPoolMonitorPointConfigConvertModel(monitorPeriodStartTime=" + this.getMonitorPeriodStartTime() + ", monitorPeriodEndTime=" + this.getMonitorPeriodEndTime() + ", monitorFrequency=" + this.getMonitorFrequency() + ", usageThreshold=" + this.getUsageThreshold() + ")";
        }
    }
}

