/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.dubbo.filter;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.fastjson.JSONObject;
import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.extend.dubbo.model.DubboThreadPoolMonitorConfigConvertModel;
import com.fshows.fsframework.extend.dubbo.model.DubboThreadPoolMonitorConfigModel;
import com.fshows.fsframework.extend.util.SpringContextUtil;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

@Activate(group={"provider"}, order=-9999)
public class GlobalDubboThreadPoolMonitor
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(GlobalDubboThreadPoolMonitor.class);
    private static final String DUBBO_THREAD_POOL_MONITOR_SWITCH = "dubbo.thread.pool.monitor.switch";
    private static final String DUBBO_THREAD_POOL_MONITOR_CONFIG = "dubbo.thread.pool.monitor.config";
    private static volatile DubboThreadPoolMonitorConfigConvertModel configModel = null;
    private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(1);
    private final Map<String, AtomicInteger> methodAndCountMap = new ConcurrentHashMap<String, AtomicInteger>();

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        DubboThreadPoolMonitorConfigConvertModel threadPoolMonitorConfigModel;
        Environment environment = SpringContextUtil.getEnvironment();
        if (environment != null && "1".equals(environment.getProperty(DUBBO_THREAD_POOL_MONITOR_SWITCH)) && (threadPoolMonitorConfigModel = this.getThreadPoolMonitorConfigModel()) != null) {
            String methodName = invoker.getUrl().getPath() + "." + invocation.getMethodName();
            this.methodAndCountMap.compute(methodName, (key, count) -> {
                if (count == null) {
                    return new AtomicInteger(1);
                }
                count.incrementAndGet();
                return count;
            });
            try {
                Result result = invoker.invoke(invocation);
                return result;
            }
            catch (RpcException e) {
                if (e.getMessage() != null && e.getMessage().toLowerCase().contains("threadpool is exhausted")) {
                    this.recordThreadPoolRunningMethod(threadPoolMonitorConfigModel.getApplicationThreadCount(), 0.0f);
                }
                throw e;
            }
            finally {
                this.methodAndCountMap.compute(methodName, (key, count) -> {
                    if (count != null && count.decrementAndGet() == 0) {
                        return null;
                    }
                    return count;
                });
            }
        }
        return invoker.invoke(invocation);
    }

    private void recordThreadPoolRunningMethod(Integer applicationThreadCount, float usageThreshold) {
        BigDecimal threshold;
        List methodAndCountList = this.methodAndCountMap.entrySet().stream().sorted((e1, e2) -> Integer.compare(((AtomicInteger)e2.getValue()).get(), ((AtomicInteger)e1.getValue()).get())).collect(Collectors.toList());
        if (usageThreshold != 0.0f && (threshold = new BigDecimal(applicationThreadCount).multiply(new BigDecimal(usageThreshold)).setScale(2)).compareTo(new BigDecimal(methodAndCountList.size())) < 0) {
            LogUtil.warn((Logger)log, (String)"record thread pool running method >> dubbo\u7ebf\u7a0b\u6c60\u5360\u7528\u65b9\u6cd5\u76d1\u63a7\uff0c\u8d85\u8fc7\u8bbe\u5b9a\u9608\u503c >> applicationThreadCount={}, usageCount={}, methodAndCountList={}", (Object[])new Object[]{applicationThreadCount, methodAndCountList.size(), methodAndCountList});
        }
        LogUtil.warn((Logger)log, (String)"record thread pool running method >> dubbo\u7ebf\u7a0b\u6c60\u5360\u7528\u65b9\u6cd5\u76d1\u63a7 >> methodAndCountList={}", (Object[])new Object[]{methodAndCountList});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DubboThreadPoolMonitorConfigConvertModel getThreadPoolMonitorConfigModel() {
        if (configModel == null) {
            GlobalDubboThreadPoolMonitor globalDubboThreadPoolMonitor = this;
            synchronized (globalDubboThreadPoolMonitor) {
                if (configModel == null) {
                    DubboThreadPoolMonitorConfigModel config;
                    Environment environment = SpringContextUtil.getEnvironment();
                    if (environment == null) {
                        return null;
                    }
                    DubboThreadPoolMonitorConfigConvertModel threadPoolMonitorConfigConvertModel = new DubboThreadPoolMonitorConfigConvertModel();
                    String threadPoolMonitorConfigStr = environment.getProperty(DUBBO_THREAD_POOL_MONITOR_CONFIG);
                    if (StrUtil.isNotBlank((CharSequence)threadPoolMonitorConfigStr) && (config = (DubboThreadPoolMonitorConfigModel)JSONObject.parseObject((String)threadPoolMonitorConfigStr, DubboThreadPoolMonitorConfigModel.class)) != null) {
                        threadPoolMonitorConfigConvertModel.setApplicationThreadCount(config.getApplicationThreadCount());
                        List<DubboThreadPoolMonitorConfigModel.ThreadPoolMonitorPointConfigModel> threadPoolMonitorPointConfigList = config.getThreadPoolMonitorPointConfigModelList();
                        if (CollUtil.isNotEmpty(threadPoolMonitorPointConfigList)) {
                            ArrayList threadPoolMonitorPointConfigConvertModelList = Lists.newArrayList();
                            for (DubboThreadPoolMonitorConfigModel.ThreadPoolMonitorPointConfigModel threadPoolMonitorPointConfigModel : threadPoolMonitorPointConfigList) {
                                String[] split;
                                if (!StrUtil.isNotBlank((CharSequence)threadPoolMonitorPointConfigModel.getMonitorPeriod()) || (split = threadPoolMonitorPointConfigModel.getMonitorPeriod().split("~")).length != 2) continue;
                                DubboThreadPoolMonitorConfigConvertModel.ThreadPoolMonitorPointConfigConvertModel threadPoolMonitorPointConfigConvertModel = new DubboThreadPoolMonitorConfigConvertModel.ThreadPoolMonitorPointConfigConvertModel();
                                threadPoolMonitorPointConfigConvertModel.setMonitorPeriodStartTime(LocalTime.parse(split[0], DateTimeFormatter.ofPattern("HH:mm:ss")));
                                threadPoolMonitorPointConfigConvertModel.setMonitorPeriodEndTime(LocalTime.parse(split[1], DateTimeFormatter.ofPattern("HH:mm:ss")));
                                threadPoolMonitorPointConfigConvertModel.setMonitorFrequency(threadPoolMonitorPointConfigModel.getMonitorFrequency());
                                threadPoolMonitorPointConfigConvertModel.setUsageThreshold(Float.parseFloat(threadPoolMonitorPointConfigModel.getUsageThreshold()));
                                threadPoolMonitorPointConfigConvertModelList.add(threadPoolMonitorPointConfigConvertModel);
                            }
                            threadPoolMonitorConfigConvertModel.setThreadPoolMonitorPointConfigList(threadPoolMonitorPointConfigConvertModelList);
                            for (DubboThreadPoolMonitorConfigConvertModel.ThreadPoolMonitorPointConfigConvertModel configConvertModel : threadPoolMonitorPointConfigConvertModelList) {
                                LocalTime start = configConvertModel.getMonitorPeriodStartTime();
                                LocalTime end = configConvertModel.getMonitorPeriodEndTime();
                                long monitorFrequency = configConvertModel.getMonitorFrequency().intValue();
                                this.scheduleTaskAtFixedRate(start, end, monitorFrequency, threadPoolMonitorConfigConvertModel.getApplicationThreadCount(), configConvertModel.getUsageThreshold());
                            }
                        }
                    }
                    configModel = threadPoolMonitorConfigConvertModel;
                }
            }
        }
        return configModel;
    }

    private void scheduleTaskAtFixedRate(LocalTime start, LocalTime end, long monitorFrequency, Integer applicationThreadCount, float usageThreshold) {
        long initialDelay = 0L;
        LocalTime nowTime = LocalTime.now();
        if (nowTime.isBefore(start)) {
            initialDelay = nowTime.until(start, ChronoUnit.SECONDS);
        }
        SCHEDULER.scheduleAtFixedRate(() -> {
            LocalTime now = LocalTime.now();
            if (now.isAfter(start) && now.isBefore(end)) {
                this.recordThreadPoolRunningMethod(applicationThreadCount, usageThreshold);
            }
        }, initialDelay, monitorFrequency, TimeUnit.SECONDS);
    }
}

