/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.dubbo.filter;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.fastjson.JSONObject;
import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.core.utils.SystemClock;
import com.fshows.fsframework.extend.dubbo.model.DubboMethodMonitorConfigConvertModel;
import com.fshows.fsframework.extend.dubbo.model.DubboMethodMonitorConfigModel;
import com.fshows.fsframework.extend.util.SpringContextUtil;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

@Activate(group={"provider", "consumer"}, order=-9999)
public class GlobalDubboMethodMonitor
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(GlobalDubboMethodMonitor.class);
    private static final String DUBBO_METHOD_MONITOR_SWITCH = "dubbo.method.monitor.switch";
    private static final String DUBBO_METHOD_MONITOR_CONFIG = "dubbo.method.monitor.config";
    private static final String PAY_COMPANY_CODE_MONITOR_METHOD = "dubbo.payCompanyCode.monitor.methods";
    private static volatile DubboMethodMonitorConfigConvertModel configModel = null;

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Map<String, List<DubboMethodMonitorConfigModel.MethodMonitorLevelConfigModel>> methodMonitorConfigMap;
        DubboMethodMonitorConfigConvertModel methodMonitorConfigModel;
        Environment environment = SpringContextUtil.getEnvironment();
        if (environment != null && "1".equals(environment.getProperty(DUBBO_METHOD_MONITOR_SWITCH)) && (methodMonitorConfigModel = this.getMethodMonitorConfigModel()) != null && CollUtil.isNotEmpty(methodMonitorConfigMap = methodMonitorConfigModel.getMethodMonitorConfigMap())) {
            String methodName = invoker.getUrl().getPath() + "." + invocation.getMethodName();
            List<DubboMethodMonitorConfigModel.MethodMonitorLevelConfigModel> methodMonitorLevelConfigModels = methodMonitorConfigMap.get(methodName);
            if (CollUtil.isEmpty(methodMonitorLevelConfigModels)) {
                methodMonitorLevelConfigModels = methodMonitorConfigMap.get("default");
            }
            if (CollUtil.isNotEmpty(methodMonitorLevelConfigModels)) {
                long rpcStartTime = SystemClock.millisClock().now();
                Result result = invoker.invoke(invocation);
                long rpcEndTime = SystemClock.millisClock().now();
                long timeConsuming = rpcEndTime - rpcStartTime;
                String payCompanyCode = null;
                Object[] arguments = invocation.getArguments();
                if (CollUtil.contains(methodMonitorConfigModel.getPayCompanyCodeMonitorMethodList(), (Object)methodName) && arguments != null && arguments.length >= 1) {
                    payCompanyCode = this.getPayCompanyCode(arguments[0]);
                }
                for (DubboMethodMonitorConfigModel.MethodMonitorLevelConfigModel methodMonitorLevelConfigModel : methodMonitorLevelConfigModels) {
                    if (timeConsuming <= (long)methodMonitorLevelConfigModel.getLowerThreshold().intValue()) continue;
                    if (payCompanyCode == null) {
                        LogUtil.warn((Logger)log, (String)"record bad-facade info >> timeConsumingLevel={}, methodName={}, arguments={}, time={}ms", (Object[])new Object[]{methodMonitorLevelConfigModel.getLevel(), methodName, arguments, timeConsuming});
                        break;
                    }
                    LogUtil.warn((Logger)log, (String)"record bad-facade info >> timeConsumingLevel={}, methodName={}, arguments={}, time={}ms, payCompanyCode={}", (Object[])new Object[]{methodMonitorLevelConfigModel.getLevel(), methodName, arguments, timeConsuming, payCompanyCode});
                    break;
                }
                return result;
            }
        }
        return invoker.invoke(invocation);
    }

    private String getPayCompanyCode(Object argument) {
        try {
            Field payCompanyCodeField = argument.getClass().getDeclaredField("payCompanyCode");
            payCompanyCodeField.setAccessible(true);
            Object payCompanyCodeObj = payCompanyCodeField.get(argument);
            if (payCompanyCodeObj != null) {
                return payCompanyCodeObj.toString();
            }
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"getPayCompanyCode >> \u83b7\u53d6\u901a\u9053\u6807\u8bc6\u53c2\u6570\u5f02\u5e38 >> argument={}", (Throwable)e, (Object[])new Object[]{argument});
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DubboMethodMonitorConfigConvertModel getMethodMonitorConfigModel() {
        if (configModel == null) {
            GlobalDubboMethodMonitor globalDubboMethodMonitor = this;
            synchronized (globalDubboMethodMonitor) {
                if (configModel == null) {
                    List payCompanyCodeMonitorMethodList;
                    String payCompanyCodeMonitorMethodStr;
                    Environment environment = SpringContextUtil.getEnvironment();
                    if (environment == null) {
                        return null;
                    }
                    DubboMethodMonitorConfigConvertModel methodMonitorConfigConvertModel = new DubboMethodMonitorConfigConvertModel();
                    String methodMonitorConfigStr = environment.getProperty(DUBBO_METHOD_MONITOR_CONFIG);
                    if (StrUtil.isNotBlank((CharSequence)methodMonitorConfigStr)) {
                        List<DubboMethodMonitorConfigModel.MethodMonitorPointConfigModel> methodMonitorPointConfigList;
                        HashMap methodMonitorConfigMap = Maps.newHashMap();
                        DubboMethodMonitorConfigModel config = (DubboMethodMonitorConfigModel)JSONObject.parseObject((String)methodMonitorConfigStr, DubboMethodMonitorConfigModel.class);
                        if (config != null && CollUtil.isNotEmpty(methodMonitorPointConfigList = config.getMethodMonitorPointConfigList())) {
                            for (DubboMethodMonitorConfigModel.MethodMonitorPointConfigModel methodMonitorPointConfigModel : methodMonitorPointConfigList) {
                                List methodMonitorLevelConfig = methodMonitorPointConfigModel.getMethodMonitorLevelConfigList().stream().sorted(Comparator.comparingInt(DubboMethodMonitorConfigModel.MethodMonitorLevelConfigModel::getLowerThreshold).reversed()).distinct().collect(Collectors.toList());
                                for (String singleMethodName : methodMonitorPointConfigModel.getMethodName().split(",")) {
                                    methodMonitorConfigMap.put(singleMethodName, methodMonitorLevelConfig);
                                }
                            }
                        }
                        methodMonitorConfigConvertModel.setMethodMonitorConfigMap(methodMonitorConfigMap);
                    }
                    if (StrUtil.isNotBlank((CharSequence)(payCompanyCodeMonitorMethodStr = environment.getProperty(PAY_COMPANY_CODE_MONITOR_METHOD))) && CollUtil.isNotEmpty((Collection)(payCompanyCodeMonitorMethodList = (List)JSONObject.parseObject((String)payCompanyCodeMonitorMethodStr, ArrayList.class)))) {
                        methodMonitorConfigConvertModel.setPayCompanyCodeMonitorMethodList(payCompanyCodeMonitorMethodList);
                    }
                    configModel = methodMonitorConfigConvertModel;
                }
            }
        }
        return configModel;
    }
}

